/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.accountingengine;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.dto.accountingengine.FinSetOfBookLineRpcDTO;
import com.elitesland.fin.dto.accountingengine.FinSetOfBookRpcDTO;
import com.elitesland.fin.param.accountingengine.FinSetOfBookSyncParam;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.service.accountingengine.FinSetOfBookRpcService;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/finSetOfBook"})
public class FinSetOfBookRpcServiceImpl
implements FinSetOfBookRpcService {
    private static final Logger log = LoggerFactory.getLogger(FinSetOfBookRpcServiceImpl.class);
    private final FinSetOfBookRepo finSettOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;

    public ApiResult<FinSetOfBookRpcDTO> findSetOfBookByCode(String sobCode) {
        List<FinSetOfBookDO> allBySobCode = this.finSettOfBookRepo.findAllBySobCode(sobCode);
        if (CollectionUtils.isEmpty(allBySobCode)) {
            return ApiResult.fail((String)(sobCode + "\u4e0d\u5b58\u5728"));
        }
        FinSetOfBookRpcDTO finSetOfBookRpcDTO = FinSetOfBookConvert.INSTANCE.doToRpcDTO(allBySobCode.get(0));
        List<FinSetOfBookLineDO> lineDOS = this.finSetOfBookLineRepo.findAllByMasId(finSetOfBookRpcDTO.getId());
        List<FinSetOfBookLineRpcDTO> lineList = FinSetOfBookLineConvert.INSTANCE.doToRpcDto(lineDOS);
        finSetOfBookRpcDTO.setDimenDetailList(lineList);
        return ApiResult.ok((Object)finSetOfBookRpcDTO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> updateSyncStatus(List<FinSetOfBookSyncParam> param) {
        log.info("\u79d1\u76ee\u8868\u540c\u6b65\u72b6\u6001\u56de\u5199, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString(param));
        for (FinSetOfBookSyncParam paramVO : param) {
            this.finSetOfBookRepoProc.updateSyncStatus(paramVO);
        }
        return ApiResult.ok();
    }

    public FinSetOfBookRpcServiceImpl(FinSetOfBookRepo finSettOfBookRepo, FinSetOfBookRepoProc finSetOfBookRepoProc, FinSetOfBookLineRepo finSetOfBookLineRepo) {
        this.finSettOfBookRepo = finSettOfBookRepo;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
    }
}

