package com.elitesland.fin.application.facade.vo.flow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 账户流水;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 */
@ApiModel(value = "账户流水", description = "账户流水")
@Data
public class AccountFlowVO extends CustomFieldBaseModelVo {
    private static final long serialVersionUID = 6171624755462812499L;


    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("公司Name")
    private String companyCodeName;

    @ApiModelProperty("归属加盟商编码")
    private String secFranchiseeCode;

    @ApiModelProperty("归属加盟商名称")
    private String secFranchiseeCodeName;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    @SysCode(sys = "yst-fin", mod = "IO_TYPE")
    private String transactionType;
    private String transactionTypeName;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    @SysCode(sys = "yst-fin", mod = "UNION_PAY")
    private String accountName;
    private String accountNameName;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    private String sourceDocName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private Long sourceId;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("账户规则编码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;

    //old

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accType;
    private String accTypeName;

    @ApiModelProperty("数据来源")
    @SysCode(sys = "yst-fin", mod = "DATA_SOURCE_TYPE")
    private String dataSource;
    private String dataSourceName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("来源平台")
    @SysCode(sys = "yst-fin", mod = "SOURCE_PLATFORM_TYPE")
    private String sourcePlatform;
    private String sourcePlatformName;

    @ApiModelProperty("账户进出方式")
    private String accIoType;
}
