package com.elitesland.fin.repo.accountingengine;

import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Repository
public interface FinSobAccountPeriodRepo extends JpaRepository<FinSobAccountPeriodDO, Long>, QuerydslPredicateExecutor<FinSobAccountPeriodDO> {

    List<FinSobAccountPeriodDO> findAllBySobCodeAndOuCode(String sobCode, String ouCode);

    List<FinSobAccountPeriodDO> findAllBySobCodeAndAccountPeriodCodeAndOuCodeIn(String sobCode, String accountPeriodCode,List<String> ouCodes);

    List<FinSobAccountPeriodDO> findAllByStatus(String status);
}
