package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArHeadDO;
import com.elitesland.fin.domain.entity.writeoff.QFinArRecVerApplyArHeadDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
@RequiredArgsConstructor
public class FinArRecVerApplyArHeadRepoProc {

    private final QFinArRecVerApplyArHeadDO QDO = QFinArRecVerApplyArHeadDO.finArRecVerApplyArHeadDO;

    private final JPAQueryFactory jpaQueryFactory;

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinArRecVerApplyArHeadDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

	public List<FinArRecVerApplyArHeadDO> listByIds(Collection<Long> ids, FinArRecVerApplyQuery query) {
        Predicate predicate = JpaPredicateBuilder.builder().getPredicate();
        if(query!=null){
            if(StrUtil.isNotEmpty(query.getOutArDocNo())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.arOrderNo.eq(query.getOutArDocNo())
                );
            }
            if(StrUtil.isNotEmpty(query.getWriteOffArOuCode())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.ouCode.eq(query.getWriteOffArOuCode())
                );
            }
            if(StrUtil.isNotEmpty(query.getWriteOffArCustCode())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.custCode.eq(query.getWriteOffArCustCode())
                );
            }
            if(StrUtil.isNotEmpty(query.getWriteOffArSalesmanCode())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.salesmanCode.eq(query.getWriteOffArSalesmanCode())
                );
            }
        }
        if(CollectionUtils.isNotEmpty(ids)){
            predicate = ExpressionUtils.and(
                    predicate,QDO.id.in(ids)
            );
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(query.getArConditions(), FinArRecVerApplyArHeadDO.class);
        if(customFieldPredicate!=null){
            //predicates.add(customFieldPredicate);
            predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
       //增加扩展字段查询条件end
		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.fetch();
	}
}
