package com.elitesland.fin.provider.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.dto.accountingengine.FinFlexibleRpcDTO;
import com.elitesland.fin.param.accountingengine.FinFlexibleValueSaveRpcParam;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.service.accountingengine.FinFlexibleRpcService;
import com.elitesland.fin.service.accountingengine.JournalGenerateRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + FinFlexibleRpcService.PATH)
@Slf4j
public class FinFlexibleRpcServiceImpl implements FinFlexibleRpcService {

    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;

    @Override
    public ApiResult<FinFlexibleRpcDTO> findFlexibleByCode(String flexibleCode) {
        List<FinFlexibleDO> code = finFlexibleRepo.findAllByFlexibleCode(flexibleCode);
        if(CollectionUtils.isEmpty(code)){
            return ApiResult.fail(code + "值集不存在");
        }
        FinFlexibleDO finFlexibleDO = code.get(0);
        FinFlexibleRpcDTO rpcDTO = FinFlexibleConvert.INSTANCE.doToRpcDTO(finFlexibleDO);

        List<FinFlexibleValueDO> valueDOList = finFlexibleValueRepo.findAllByMasIdAndDeleteFlag(finFlexibleDO.getId(), 0);
        if(CollectionUtils.isNotEmpty(valueDOList)){
            rpcDTO.setDetailList(FinFlexibleValueConvert.INSTANCE.doToRpcDTO(valueDOList));
        }
        return ApiResult.ok(rpcDTO);
    }

    @Override
    public ApiResult<Void> batchSave(List<FinFlexibleValueSaveRpcParam> paramList) {
        List<FinFlexibleValueSaveRpcParam> list = paramList.stream().filter(t -> t.getMasId() == null).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(list)){
            throw new RuntimeException("masId缺失");
        }
        paramList.forEach(item -> {
            Assert.notNull(item.getMasId(), "masId必填");
            Assert.notNull(item.getSerialNum(), "序号必填");
            Assert.notEmpty(item.getFlexibleValueCode(), "值必填");
            Assert.notEmpty(item.getFlexibleValueName(), "值名称必填");
            Assert.notNull(item.getDescendantsFlag(), "是否有子代必填");
            Assert.notNull(item.getActiveFlag(), "是否启用必填");
            Assert.notNull(item.getAccountFlag(), "是否记账必填");
            Assert.notNull(item.getActiveStartTime(), "起始有效日期必填");
            Assert.notNull(item.getActiveEndTime(), "终止有效日期必填");

            // 页面是自己选的，这里先不做校验
//            if (StringUtils.isNotEmpty(finFlexibleParam.getParentFlexibleCode())) {
//                Assert.notEmpty(item.getMasFlexibleValueCode(), "主值必填");
//                Assert.notEmpty(item.getMasFlexibleValueName(), "主值名称必填");
//            }
        });

        List<FinFlexibleValueDO> valueDOS = FinFlexibleValueConvert.INSTANCE.rpcParamToDO(paramList);
        finFlexibleValueRepo.saveAll(valueDOS);
        return ApiResult.ok();
    }
}
