package com.elitesland.fin.provider.aporder;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.dto.aporder.ApArOrderHandleRpcDTO;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.param.aporder.*;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.aporder
 * @date 2022/5/17 16:07
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ApOrderRpcService.PATH)
public class ApOrderRpcServiceImpl implements ApOrderRpcService {


    public final ApOrderDomainService apOrderDomainService;
    public final InputInvService inputInvService;
    public final ApArOrderService apArOrderService;


    @Override
    public ApiResult<Long> save(ApOrderRpcParam apOrderRpcParam) {
        if (StringUtils.isBlank(apOrderRpcParam.getCreateMode())) {
            throw new BusinessException("单据来源 createMode不能为空");
        }
        // DTO转
        ApOrder apOrder = ApOrderConvert.INSTANCE.convertRpc(apOrderRpcParam);
        Long resId = apOrderDomainService.save(apOrder);
        if(Boolean.TRUE.equals(apOrderRpcParam.getWriteInvFlag())){
            //回写发票应收单号
            ApOrderDTO apOrderDTO = apOrderDomainService.get(resId);
            inputInvService.savaApOrderNo(apOrderRpcParam.getCreateMode(),apOrderRpcParam.getSourceNo(),apOrderDTO.getApOrderNo());
        }
        return ApiResult.ok(resId);
    }

    @Override
    public ApiResult<ApOrderRpcDTO> queryApOrderById(Long id) {

        ApOrderDTO apOrderDTO = apOrderDomainService.getApOrderAndDtl(id);
        return ApiResult.ok(ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO(apOrderDTO));
    }

    @Override
    public ApiResult<PagingVO<ApOrderRpcDTO>> page(ApOrderPageRpcParam apOrderPageRpcParam) {
        ApOrderPageParam apOrderPageParam = ApOrderConvert.INSTANCE.convertPageParamRpc(apOrderPageRpcParam);
        PagingVO<ApOrderRpcDTO> res = ApOrderConvert.INSTANCE.convertRpcDto(apOrderDomainService.page(apOrderPageParam));
        return ApiResult.ok(res);
    }


    @Override
    public ApiResult<ApArOrderHandleRpcDTO> invInterTranGenApAr(@RequestBody ApArOrderHandleRpcParam apArOrderRpcParam){
        ApArOrderHandleRpcDTO apArOrderHandleRpcDTO = new ApArOrderHandleRpcDTO();


        ApOrder apOrder = ApOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getApOrderRpcParam());
        ArOrder arOrder = ArOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getArOrderRpcParam());

        ApArOrderHandleDTO apArOrderHandleDTO = apArOrderService.invInterTranCreateApArOrder(apOrder,arOrder);
        apArOrderHandleRpcDTO.setArResId(apArOrderHandleDTO.getArResId());
        apArOrderHandleRpcDTO.setArOrderNo(apArOrderHandleDTO.getArOrderNo());
        apArOrderHandleRpcDTO.setApResId(apArOrderHandleDTO.getApResId());
        apArOrderHandleRpcDTO.setApOrderNo(apArOrderHandleDTO.getApOrderNo());

        return ApiResult.ok(apArOrderHandleRpcDTO);
    }

    @Override
    public ApiResult<List<ApOrderRpcDTO>> findSyncApOrder(ApOrderSyncRpcParam param) {
        List<ApOrderDTO> syncApOrder = apOrderDomainService.findSyncApOrder(param);
        if(CollectionUtils.isEmpty(syncApOrder)){
            return ApiResult.ok(new ArrayList<>());
        }
        List<ApOrderRpcDTO> results = syncApOrder.stream().map(t -> {
            ApOrderRpcDTO apOrderRpcDTO = ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO(t);
            if(CollectionUtils.isNotEmpty(t.getApOrderDtlDTOList())){
                apOrderRpcDTO.setApOrderDtlRpcDTOList(t.getApOrderDtlDTOList().stream()
                        .map(ApOrderDtlConvert.INSTANCE::dtlToRpcDtl).collect(Collectors.toList()));
            } else {
                apOrderRpcDTO.setApOrderDtlRpcDTOList(new ArrayList<>());
            }
            return apOrderRpcDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(results);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Void> updateSyncStatus(List<ApOrderSyncResultRpcParam> param) {
        log.info("资产卡片同步金蝶状态回写, 时间：{}，入参：{}", LocalDateTime.now(), JSONObject.toJSONString(param));
        apOrderDomainService.updateSyncStatus(param);
        return ApiResult.ok();
    }

}
