/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.application.facade.param.arorder.ApOrderRefreshParam;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.inv.dto.invTrn.InvTrnDRpcDTO;
import com.elitesland.inv.dto.invTrn.InvTrnDRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDTO;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.inv.provider.InvTrnProvider;
import com.elitesland.order.param.SalDoDFinQueryDTO;
import com.elitesland.order.param.SalDoDFinRespDTO;
import com.elitesland.order.service.SalDoDRpcService;
import com.elitesland.pur.base.BaseModelVO;
import com.elitesland.pur.dto.gr.PurGrDParamRpcDTO;
import com.elitesland.pur.dto.gr.PurGrDRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.provider.PurGrDProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ApArOrderServiceImpl
implements ApArOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApArOrderServiceImpl.class);
    private final InvStkProvider invStkProvider;
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final TransactionTemplate transactionTemplate;
    private final SystemRpcService systemRpcService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final SalDoDRpcService salDoDRpcService;
    private final PurGrDProvider purGrDProvider;
    private final InvTrnProvider invTrnProvider;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final FinApPayVerApplyService finApPayVerApplyService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final TaskExecutor taskExecutor;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;

    @Override
    public void logicInvIoJobAutoCreateApArOrder(String param) {
        JSONObject jsonObject;
        ApArOrderParam apArOrderJobParam;
        ApArOrderParam apArOrderParam = new ApArOrderParam();
        if (StringUtils.isNotBlank((CharSequence)param) && Objects.nonNull(apArOrderJobParam = (ApArOrderParam)JSONObject.toJavaObject((JSON)(jsonObject = JSONObject.parseObject((String)param)), ApArOrderParam.class))) {
            ArOrderRecordConvert.INSTANCE.oldApArOrderToNewParam(apArOrderJobParam, apArOrderParam);
        }
        this.logicInvIoCreateApArOrder(apArOrderParam);
    }

    @Override
    public void logicInvIoCreateApArOrder(ApArOrderParam param) {
        log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
        log.info("\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e\u4efb\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)param));
        InvIoFinReceiptRpcDtoParam invIoFinReceiptRpcDtoParam = new InvIoFinReceiptRpcDtoParam();
        invIoFinReceiptRpcDtoParam.setIdList(null);
        invIoFinReceiptRpcDtoParam.setSceneCodeList(param.getSceneCodeList());
        invIoFinReceiptRpcDtoParam.setFinInterFlagList(param.getFinInterFlagList());
        List invIoFinReceiptRpcDTOList = this.invStkProvider.selectLogicInvIoByParam(invIoFinReceiptRpcDtoParam);
        if (CollectionUtil.isEmpty((Collection)invIoFinReceiptRpcDTOList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34");
            return;
        }
        List<String> suppCodeList = invIoFinReceiptRpcDTOList.stream().map(InvIoFinReceiptRpcDTO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, PurSuppBaseRpcDTO> suppMap = this.purSuppOutService.findSimpleSuppMapByCodes(suppCodeList);
        List<String> custCodeList = invIoFinReceiptRpcDTOList.stream().map(InvIoFinReceiptRpcDTO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, CustBaseDTO> custMap = this.rmiSaleRpcService.findBaseCustMapByCodes(custCodeList);
        Map<String, List<InvIoFinReceiptRpcDTO>> srcDocNoListMap = invIoFinReceiptRpcDTOList.stream().collect(Collectors.groupingBy(i -> i.getSrcDocNo()));
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> srcDocNoEntry : srcDocNoListMap.entrySet()) {
            String srcDocNoKey = srcDocNoEntry.getKey();
            List<InvIoFinReceiptRpcDTO> srcDocNoList = srcDocNoEntry.getValue();
            this.transactionTemplate.setPropagationBehavior(3);
            ApArOrderHandleDTO handleDTO = (ApArOrderHandleDTO)this.transactionTemplate.execute(trans -> {
                ApArOrderHandleDTO apArOrderHandleDTO = new ApArOrderHandleDTO();
                apArOrderHandleDTO.setLogicInvIoCreateFlag(false);
                try {
                    BigDecimal apAllTotalAmt;
                    BigDecimal arAllTotalAmt;
                    List soLogicDeliveryList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "SO_LOGIC_DELIVERY")).collect(Collectors.toList());
                    List soLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "SO_LOGIC_RECEIPT")).collect(Collectors.toList());
                    List poLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "PO_LOGIC_RECEIPT")).collect(Collectors.toList());
                    List poLogicReturnList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "PO_LOGIC_RETURN")).collect(Collectors.toList());
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicDeliveryListMap = soLogicDeliveryList.stream().collect(Collectors.groupingBy(i -> this.arSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicReceiptListMap = soLogicReceiptList.stream().collect(Collectors.groupingBy(i -> this.arSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReceiptListMap = poLogicReceiptList.stream().collect(Collectors.groupingBy(i -> this.apSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReturnListMap = poLogicReturnList.stream().collect(Collectors.groupingBy(i -> this.apSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    ArrayList<ArOrder> arOrderList = new ArrayList<ArOrder>();
                    ArrayList<ApOrder> apOrderList = new ArrayList<ApOrder>();
                    if (MapUtil.isNotEmpty(soLogicDeliveryListMap)) {
                        ApArOrderHandleDTO soLogicDeliveryHandleDTO = this.logicInvIoHandle(soLogicDeliveryListMap, srcDocNoKey, suppMap, custMap);
                        arOrderList.addAll(soLogicDeliveryHandleDTO.getArOrderList());
                        apOrderList.addAll(soLogicDeliveryHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(soLogicReceiptListMap)) {
                        ApArOrderHandleDTO soLogicReceiptHandleDTO = this.logicInvIoHandle(soLogicReceiptListMap, srcDocNoKey, suppMap, custMap);
                        arOrderList.addAll(soLogicReceiptHandleDTO.getArOrderList());
                        apOrderList.addAll(soLogicReceiptHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(poLogicReceiptListMap)) {
                        ApArOrderHandleDTO poLogicReceiptHandleDTO = this.logicInvIoHandle(poLogicReceiptListMap, srcDocNoKey, suppMap, custMap);
                        arOrderList.addAll(poLogicReceiptHandleDTO.getArOrderList());
                        apOrderList.addAll(poLogicReceiptHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(poLogicReturnListMap)) {
                        ApArOrderHandleDTO poLogicReturnHandleDTO = this.logicInvIoHandle(poLogicReturnListMap, srcDocNoKey, suppMap, custMap);
                        arOrderList.addAll(poLogicReturnHandleDTO.getArOrderList());
                        apOrderList.addAll(poLogicReturnHandleDTO.getApOrderList());
                    }
                    if ((arAllTotalAmt = arOrderList.stream().filter(Objects::nonNull).map(ArOrder::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(apAllTotalAmt = apOrderList.stream().filter(Objects::nonNull).map(ApOrder::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                        log.error("\u6765\u6e90\u5355\u636e\u7f16\u53f7: {} \u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u548c\u5e94\u4ed8\u5355\u7684\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49", (Object)srcDocNoKey);
                        throw new BusinessException("\u6765\u6e90\u5355\u636e\u7f16\u53f7:(" + srcDocNoKey + ")\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u548c\u5e94\u4ed8\u5355\u7684\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49");
                    }
                    apArOrderHandleDTO.setLogicInvIoCreateFlag(true);
                    return apArOrderHandleDTO;
                }
                catch (Exception e) {
                    log.error("\u6765\u6e90\u5355\u636e\u7f16\u53f7: {} \u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u539f\u56e0: {}", (Object)srcDocNoKey, (Object)e.getMessage());
                    apArOrderHandleDTO.setLogicInvIoCreateFlag(false);
                    apArOrderHandleDTO.setFinErrorMsg(e.getMessage());
                    trans.setRollbackOnly();
                    return apArOrderHandleDTO;
                }
            });
            List invIoIds = srcDocNoList.stream().map(InvIoFinReceiptRpcDTO::getId).collect(Collectors.toList());
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIds);
            if (handleDTO.getLogicInvIoCreateFlag().booleanValue()) {
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_1);
                this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
                continue;
            }
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_2);
            invIoFinReceiptSaveRpcParam.setFinErrorMsg(handleDTO.getFinErrorMsg());
            this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }
    }

    private ApArOrderHandleDTO logicInvIoHandle(Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap, String srcDocNoKey, Map<String, PurSuppBaseRpcDTO> suppMap, Map<String, CustBaseDTO> custMap) {
        ApArOrderHandleDTO apArOrderHandleDTO = new ApArOrderHandleDTO();
        ArrayList<ArOrder> arOrderList = new ArrayList<ArOrder>();
        ArrayList<ApOrder> apOrderList = new ArrayList<ApOrder>();
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> spliceGroupEntry : spliceGroupListMap.entrySet()) {
            ApOrder apOrder;
            ArOrder arOrder;
            String spliceGroupKey = spliceGroupEntry.getKey();
            List<InvIoFinReceiptRpcDTO> spliceGroupList = spliceGroupEntry.getValue();
            String sceneCode = spliceGroupList.get(0).getSceneCode();
            if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
                arOrder = this.assembleArOrder(spliceGroupList, custMap);
                arOrderList.add(arOrder);
                continue;
            }
            if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
                arOrder = this.assembleArOrder(spliceGroupList, custMap);
                arOrderList.add(arOrder);
                continue;
            }
            if (Objects.equals(sceneCode, "PO_LOGIC_RECEIPT")) {
                apOrder = this.assembleApOrder(spliceGroupList, suppMap);
                apOrderList.add(apOrder);
                continue;
            }
            if (Objects.equals(sceneCode, "PO_LOGIC_RETURN")) {
                apOrder = this.assembleApOrder(spliceGroupList, suppMap);
                apOrderList.add(apOrder);
                continue;
            }
            log.info("\u8be5\u5355\u53f7(" + srcDocNoKey + ")\u7684\u573a\u666f\u7801(" + sceneCode + ")\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u573a\u666f");
            throw new BusinessException("\u8be5\u5355\u53f7(" + srcDocNoKey + ")\u7684\u573a\u666f\u7801(" + sceneCode + ")\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u573a\u666f");
        }
        apArOrderHandleDTO.setArOrderList(arOrderList);
        apArOrderHandleDTO.setApOrderList(apOrderList);
        return apArOrderHandleDTO;
    }

    private ArOrder assembleArOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList, Map<String, CustBaseDTO> custMap) {
        CustBaseDTO custBaseDTO;
        ArOrder arOrder = new ArOrder();
        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();
        ArTypeDTO arTypeDTO = this.selectArType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(), sceneCode, UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(), invIoFinReceiptRpcDTO.getOuId(), invIoFinReceiptRpcDTO.getOuCode());
        Boolean isAuto = arTypeDTO.getAutoAudit();
        arOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        arOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        arOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        arOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        arOrder.setBuDate(invIoFinReceiptRpcDTO.getFinDate());
        arOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        arOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("\u4eba\u6c11\u5e01");
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setExchangeRate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setAuditRejection(null);
        arOrder.setCustId(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setCustCode(invIoFinReceiptRpcDTO.getCustCode());
        arOrder.setCustName(invIoFinReceiptRpcDTO.getCustName());
        if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custBaseDTO = custMap.get(invIoFinReceiptRpcDTO.getCustCode()))) {
            arOrder.setCustName(custBaseDTO.getCustName());
        }
        arOrder.setInOutCust(null);
        arOrder.setRelevanceOuCode(null);
        arOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setBuType(null);
        arOrder.setProtocolCode(null);
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);
        arOrder.setOrgId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setOrgCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setOrgName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        arOrder.setArOrderType(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setApprovedTime(null);
        arOrder.setDocType2("B");
        if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
            arOrder.setDocCls("SO");
        } else if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
            arOrder.setDocCls("RSO");
        }
        arOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        arOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        arOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setSettlementType(null);
        String es1 = Objects.isNull(invIoFinReceiptRpcDTO.getCustId()) ? null : String.valueOf(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setEs1(es1);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        arOrder.setEs6(UdcEnum.RED_STATE_NO.getValueCode());
        String docType = null;
        List<ArOrderDtl> arOrderDtlList = this.assembleArOrderDtl(arOrder, spliceGroupList, null, sceneCode, docType, custMap);
        arOrder.setDtlList(arOrderDtlList);
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);
        arOrder.setDocType(docType);
        arOrder.setAuditDate(LocalDateTime.now());
        arOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        SysUserDTO user = this.systemRpcService.getUserByName("admin");
        arOrder.setAuditUserId(user.getId());
        Long arOrderId = this.arOrderDomainService.newCommit(arOrder, true);
        CompletableFuture.runAsync(() -> {
            ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(arOrderId);
            this.finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
        }, (Executor)this.taskExecutor);
        return arOrder;
    }

    private List<ArOrderDtl> assembleArOrderDtl(ArOrder arOrder, List<InvIoFinReceiptRpcDTO> spliceGroupList, Long masId, String sceneCode, String docType, Map<String, CustBaseDTO> custMap) {
        Set salDoCurrCodes;
        Set purGrCurrCodes;
        List<Long> purGrdIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_GR.getValueCode()) || Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_RGR.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = this.selectPurGrdById(purGrdIds);
        List<Long> salDodIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_DO.getValueCode()) || Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_RDO.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDRpcDTOList = this.selectSalDodById(salDodIds);
        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList)) {
            docType = salDoDRpcDTOList.get(0).getDocType();
        }
        List<Long> invTrndIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_STKTRN.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<InvTrnDRpcDTO> invTrnDRpcDTOList = this.selectInvTrndById(invTrndIds);
        HashMap purGrDMap = CollectionUtil.isEmpty(purGrDRpcDTOList) ? new HashMap() : purGrDRpcDTOList.stream().collect(Collectors.toMap(BaseModelVO::getId, t -> t, (t1, t2) -> t1));
        HashMap salDoDMap = CollectionUtil.isEmpty(salDoDRpcDTOList) ? new HashMap() : salDoDRpcDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));
        HashMap invTrnDMap = CollectionUtil.isEmpty(invTrnDRpcDTOList) ? new HashMap() : invTrnDRpcDTOList.stream().collect(Collectors.toMap(InvTrnDRpcDTO::getId, t -> t, (t1, t2) -> t1));
        HashSet<String> currCodes = new HashSet<String>();
        if (CollectionUtil.isNotEmpty(purGrDRpcDTOList) && CollectionUtil.isNotEmpty(purGrCurrCodes = purGrDRpcDTOList.stream().map(PurGrDRpcDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet()))) {
            currCodes.addAll(purGrCurrCodes);
        }
        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList) && CollectionUtil.isNotEmpty(salDoCurrCodes = salDoDRpcDTOList.stream().map(SalDoDFinRespDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet()))) {
            currCodes.addAll(salDoCurrCodes);
        }
        Map<String, String> currMap = this.selectCurrByCode(currCodes);
        List<ArOrderDtl> arOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = (PurGrDRpcDTO)purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            SalDoDFinRespDTO salDoDRpcDTO = (SalDoDFinRespDTO)salDoDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            InvTrnDRpcDTO invTrnDRpcDTO = (InvTrnDRpcDTO)invTrnDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            CustBaseDTO custBaseDTO = (CustBaseDTO)custMap.get(invIoFinReceiptRpcDTO.getCustCode());
            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setInvIoId(invIoFinReceiptRpcDTO.getId());
            arOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            Boolean purGrdFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_GR.getValueCode()) || Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_RGR.getValueCode())) {
                purGrdFlag = true;
            }
            Boolean salDodFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_DO.getValueCode()) || Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_RDO.getValueCode())) {
                salDodFlag = true;
            }
            if (purGrdFlag.booleanValue() && Objects.nonNull(purGrDRpcDTO)) {
                if (Objects.nonNull(purGrDRpcDTO.getLineNo())) {
                    arOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)purGrDRpcDTO.getCurrCode())) {
                    arOrder.setCurrCode(purGrDRpcDTO.getCurrCode());
                    arOrder.setCurrName((String)currMap.get(purGrDRpcDTO.getCurrCode()));
                }
                if (Objects.nonNull(purGrDRpcDTO.getCurrRate())) {
                    arOrder.setExchangeRate(BigDecimal.valueOf(purGrDRpcDTO.getCurrRate()));
                }
            } else if (salDodFlag.booleanValue() && Objects.nonNull(salDoDRpcDTO)) {
                if (Objects.nonNull(salDoDRpcDTO.getLineNo())) {
                    arOrderDtl.setSourceLine(salDoDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)salDoDRpcDTO.getCurrCode())) {
                    arOrder.setCurrCode(salDoDRpcDTO.getCurrCode());
                    arOrder.setCurrName((String)currMap.get(salDoDRpcDTO.getCurrCode()));
                }
                if (Objects.nonNull(salDoDRpcDTO.getCurrRate())) {
                    arOrder.setExchangeRate(salDoDRpcDTO.getCurrRate());
                }
                if (Objects.nonNull(salDoDRpcDTO.getAgentEmpId())) {
                    arOrder.setSaleUserId(salDoDRpcDTO.getAgentEmpId());
                    arOrder.setSaleUser(salDoDRpcDTO.getAgentName());
                }
            } else if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_STKTRN.getValueCode())) {
                if (Objects.nonNull(invTrnDRpcDTO) && Objects.nonNull(invTrnDRpcDTO.getLineNo())) {
                    arOrderDtl.setSourceLine(invTrnDRpcDTO.getLineNo().intValue());
                }
                arOrder.setCurrCode("CNY");
                arOrder.setCurrName("\u4eba\u6c11\u5e01");
                arOrder.setExchangeRate(BigDecimal.ONE);
            } else {
                arOrderDtl.setSourceLine(null);
            }
            arOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            arOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            arOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            arOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            arOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            arOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            arOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            arOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());
            BigDecimal qty = invIoFinReceiptRpcDTO.getQty().abs();
            BigDecimal price = invIoFinReceiptRpcDTO.getSalePrice();
            BigDecimal saleAmt = invIoFinReceiptRpcDTO.getSaleAmt();
            BigDecimal costPrice = invIoFinReceiptRpcDTO.getCostPrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRateOut();
            if (Objects.isNull(price)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(taxRate)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
            }
            BigDecimal exclTaxPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = saleAmt;
            BigDecimal exclTaxAmt = totalAmt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
                arOrderDtl.setQty(qty);
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt);
                arOrderDtl.setExclTaxAmt(exclTaxAmt);
                arOrderDtl.setTaxAmt(taxAmt);
                arOrderDtl.setTotalCurAmt(totalAmt);
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                arOrderDtl.setTaxCurAmt(taxAmt);
            } else if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
                arOrderDtl.setQty(qty.negate());
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt.negate());
                arOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxAmt(taxAmt.negate());
                arOrderDtl.setTotalCurAmt(totalAmt.negate());
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxCurAmt(taxAmt.negate());
            }
            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            arOrderDtl.setExpensesType(null);
            arOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            arOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            arOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            arOrderDtl.setEs11(invIoFinReceiptRpcDTO.getSrcDocNo());
            arOrderDtl.setEs12(invIoFinReceiptRpcDTO.getSrcDocDid());
            arOrderDtl.setEs13(String.valueOf(invIoFinReceiptRpcDTO.getCustId()));
            arOrderDtl.setEs14(invIoFinReceiptRpcDTO.getCustCode());
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            if (Objects.nonNull(custBaseDTO)) {
                if (StringUtils.isBlank((CharSequence)custBaseDTO.getPaymentTerm())) {
                    throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u5ba2\u6237(" + invIoFinReceiptRpcDTO.getCustCode() + ")\u7684\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a");
                }
            } else {
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            arOrderDtl.setEs19(custBaseDTO.getPaymentTerm());
            arOrderDtl.setProtocolCode(custBaseDTO.getPaymentTerm());
            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            arOrderDtl.setRelateId(null);
            return arOrderDtl;
        }).collect(Collectors.toList());
        return arOrderDtlList;
    }

    private ApOrder assembleApOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList, Map<String, PurSuppBaseRpcDTO> suppMap) {
        PurSuppBaseRpcDTO purSuppBaseRpcDTO;
        ApOrder apOrder = new ApOrder();
        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();
        apOrder.setId(null);
        apOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        apOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        apOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        apOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        ApTypeDTO apTypeDTO = this.selectApType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(), sceneCode, UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(), invIoFinReceiptRpcDTO.getOuId(), invIoFinReceiptRpcDTO.getOuCode());
        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        apOrder.setBuDate(invIoFinReceiptRpcDTO.getFinDate());
        apOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setExchangeRate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setAuditRejection(null);
        apOrder.setSuppId(invIoFinReceiptRpcDTO.getSuppId());
        apOrder.setSuppCode(invIoFinReceiptRpcDTO.getSuppCode());
        apOrder.setSuppName(invIoFinReceiptRpcDTO.getSuppName());
        if (MapUtil.isNotEmpty(suppMap) && Objects.nonNull(purSuppBaseRpcDTO = suppMap.get(invIoFinReceiptRpcDTO.getSuppCode()))) {
            apOrder.setSuppName(purSuppBaseRpcDTO.getSuppName());
        }
        apOrder.setInOutCust(null);
        apOrder.setRelevanceOuCode(null);
        apOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        apOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        apOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        apOrder.setBuType(null);
        apOrder.setPayMentName("\u7acb\u5373");
        apOrder.setPayMentId("1");
        apOrder.setPayMentCode(" A00");
        apOrder.setProtocolCode(null);
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setLocalCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        apOrder.setVerAmt(BigDecimal.ZERO);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        apOrder.setApprovedTime(null);
        apOrder.setAddrNo(null);
        apOrder.setSuppAddrNo(null);
        apOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        apOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        apOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        List<ApOrderDtl> apOrderDtlList = this.assembleApOrderDtl(apOrder, spliceGroupList, null, sceneCode, suppMap);
        apOrder.setApOrderDtlList(apOrderDtlList);
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);
        List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
        apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        apOrder.setAuditDate(LocalDateTime.now());
        apOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        SysUserDTO user = this.systemRpcService.getUserByName("admin");
        apOrder.setAuditUserId(user.getId());
        apOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        Long apOrderId = this.apOrderDomainService.newCommit(apOrder);
        CompletableFuture.runAsync(() -> {
            ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(apOrderId);
            this.finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
        }, (Executor)this.taskExecutor);
        return apOrder;
    }

    private List<ApOrderDtl> assembleApOrderDtl(ApOrder apOrder, List<InvIoFinReceiptRpcDTO> spliceGroupList, Long masId, String sceneCode, Map<String, PurSuppBaseRpcDTO> suppMap) {
        Set salDoCurrCodes;
        Set purGrCurrCodes;
        List<Long> purGrdIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_GR.getValueCode()) || Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_RGR.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = this.selectPurGrdById(purGrdIds);
        List<Long> salDodIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_DO.getValueCode()) || Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_RDO.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDRpcDTOList = this.selectSalDodById(salDodIds);
        List<Long> invTrndIds = spliceGroupList.stream().filter(invIoSpliceGroupDto -> Objects.equals(invIoSpliceGroupDto.getSrcDocCls(), UdcEnum.DOC_CLS_STKTRN.getValueCode())).map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<InvTrnDRpcDTO> invTrnDRpcDTOList = this.selectInvTrndById(invTrndIds);
        HashMap purGrDMap = CollectionUtil.isEmpty(purGrDRpcDTOList) ? new HashMap() : purGrDRpcDTOList.stream().collect(Collectors.toMap(BaseModelVO::getId, t -> t, (t1, t2) -> t1));
        HashMap salDoDMap = CollectionUtil.isEmpty(salDoDRpcDTOList) ? new HashMap() : salDoDRpcDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));
        HashMap invTrnDMap = CollectionUtil.isEmpty(invTrnDRpcDTOList) ? new HashMap() : invTrnDRpcDTOList.stream().collect(Collectors.toMap(InvTrnDRpcDTO::getId, t -> t, (t1, t2) -> t1));
        HashSet<String> currCodes = new HashSet<String>();
        if (CollectionUtil.isNotEmpty(purGrDRpcDTOList) && CollectionUtil.isNotEmpty(purGrCurrCodes = purGrDRpcDTOList.stream().map(PurGrDRpcDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet()))) {
            currCodes.addAll(purGrCurrCodes);
        }
        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList) && CollectionUtil.isNotEmpty(salDoCurrCodes = salDoDRpcDTOList.stream().map(SalDoDFinRespDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet()))) {
            currCodes.addAll(salDoCurrCodes);
        }
        Map<String, String> currMap = this.selectCurrByCode(currCodes);
        List<ApOrderDtl> apOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = (PurGrDRpcDTO)purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            SalDoDFinRespDTO salDoDRpcDTO = (SalDoDFinRespDTO)salDoDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            InvTrnDRpcDTO invTrnDRpcDTO = (InvTrnDRpcDTO)invTrnDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            PurSuppBaseRpcDTO purSuppBaseRpcDTO = (PurSuppBaseRpcDTO)suppMap.get(invIoFinReceiptRpcDTO.getSuppCode());
            ApOrderDtl apOrderDtl = new ApOrderDtl();
            apOrderDtl.setMasId(masId);
            apOrderDtl.setInvIoId(invIoFinReceiptRpcDTO.getId());
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            Boolean purGrdFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_GR.getValueCode()) || Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_RGR.getValueCode())) {
                purGrdFlag = true;
            }
            Boolean salDodFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_DO.getValueCode()) || Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_RDO.getValueCode())) {
                salDodFlag = true;
            }
            if (purGrdFlag.booleanValue() && Objects.nonNull(purGrDRpcDTO)) {
                if (Objects.nonNull(purGrDRpcDTO.getLineNo())) {
                    apOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)purGrDRpcDTO.getCurrCode())) {
                    apOrder.setCurrCode(purGrDRpcDTO.getCurrCode());
                    apOrder.setCurrName((String)currMap.get(purGrDRpcDTO.getCurrCode()));
                    apOrder.setLocalCurrCode(purGrDRpcDTO.getCurrCode());
                    apOrder.setLocalCurrName((String)currMap.get(purGrDRpcDTO.getCurrCode()));
                }
                if (Objects.nonNull(purGrDRpcDTO.getCurrRate())) {
                    apOrder.setExchangeRate(BigDecimal.valueOf(purGrDRpcDTO.getCurrRate()));
                }
            } else if (salDodFlag.booleanValue() && Objects.nonNull(salDoDRpcDTO)) {
                if (Objects.nonNull(salDoDRpcDTO.getLineNo())) {
                    apOrderDtl.setSourceLine(salDoDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)salDoDRpcDTO.getCurrCode())) {
                    apOrder.setCurrCode(salDoDRpcDTO.getCurrCode());
                    apOrder.setCurrName((String)currMap.get(salDoDRpcDTO.getCurrCode()));
                    apOrder.setLocalCurrCode(salDoDRpcDTO.getCurrCode());
                    apOrder.setLocalCurrName((String)currMap.get(salDoDRpcDTO.getCurrCode()));
                }
                if (Objects.nonNull(salDoDRpcDTO.getCurrRate())) {
                    apOrder.setExchangeRate(salDoDRpcDTO.getCurrRate());
                }
                if (Objects.nonNull(salDoDRpcDTO.getAgentEmpId())) {
                    // empty if block
                }
            } else if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(), UdcEnum.DOC_CLS_STKTRN.getValueCode())) {
                if (Objects.nonNull(invTrnDRpcDTO) && Objects.nonNull(invTrnDRpcDTO.getLineNo())) {
                    apOrderDtl.setSourceLine(invTrnDRpcDTO.getLineNo().intValue());
                }
                apOrder.setCurrCode("CNY");
                apOrder.setCurrName("\u4eba\u6c11\u5e01");
                apOrder.setLocalCurrCode("CNY");
                apOrder.setLocalCurrName("\u4eba\u6c11\u5e01");
                apOrder.setExchangeRate(BigDecimal.ONE);
            } else {
                apOrderDtl.setSourceLine(null);
            }
            apOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            apOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            apOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            apOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            apOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            apOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            apOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            apOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());
            BigDecimal qty = invIoFinReceiptRpcDTO.getQty().abs();
            BigDecimal price = invIoFinReceiptRpcDTO.getSalePrice();
            BigDecimal saleAmt = invIoFinReceiptRpcDTO.getSaleAmt();
            BigDecimal costPrice = invIoFinReceiptRpcDTO.getCostPrice();
            if (Objects.isNull(costPrice)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u5355\u4f4d\u6210\u672c\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u5355\u4f4d\u6210\u672c\u4e3a\u7a7a");
            }
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRate();
            if (Objects.isNull(price)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(taxRate)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
            }
            BigDecimal exclTaxPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = saleAmt;
            BigDecimal exclTaxAmt = totalAmt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.equals(sceneCode, "PO_LOGIC_RECEIPT")) {
                apOrderDtl.setQty(qty);
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt);
                apOrderDtl.setExclTaxAmt(exclTaxAmt);
                apOrderDtl.setTaxAmt(taxAmt);
                apOrderDtl.setTotalCurAmt(totalAmt);
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                apOrderDtl.setTaxCurAmt(taxAmt);
            } else if (Objects.equals(sceneCode, "PO_LOGIC_RETURN")) {
                apOrderDtl.setQty(qty.negate());
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt.negate());
                apOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxAmt(taxAmt.negate());
                apOrderDtl.setTotalCurAmt(totalAmt.negate());
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxCurAmt(taxAmt.negate());
            }
            apOrderDtl.setCostPrice(costPrice);
            apOrderDtl.setCostAmt(invIoFinReceiptRpcDTO.getCostAmt());
            apOrderDtl.setInvoicePriceVariance(null);
            apOrderDtl.setPurRecvWhId(invIoFinReceiptRpcDTO.getWhId());
            apOrderDtl.setPurRecvWhCode(invIoFinReceiptRpcDTO.getWhCode());
            apOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            apOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            apOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            apOrderDtl.setSourceNoDid(invIoFinReceiptRpcDTO.getSrcDocDid());
            if (Objects.nonNull(purSuppBaseRpcDTO)) {
                if (StringUtils.isBlank((CharSequence)purSuppBaseRpcDTO.getProtocolCode())) {
                    throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u4f9b\u5e94\u5546(" + invIoFinReceiptRpcDTO.getSuppCode() + ")\u7684\u4ed8\u6b3e\u534f\u8bae\u4e3a\u7a7a");
                }
            } else {
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
            }
            apOrderDtl.setProtocolCode(purSuppBaseRpcDTO.getProtocolCode());
            return apOrderDtl;
        }).collect(Collectors.toList());
        return apOrderDtlList;
    }

    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        ArrayList<ApOrderDtlGroup> resList = new ArrayList<ApOrderDtlGroup>();
        for (Map.Entry<String, List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
        }
        return resList;
    }

    private ArTypeDTO selectArType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId, String ouCode) {
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(sourceDoc);
        arTypePageParam.setSourceDocType(sourceDocType);
        arTypePageParam.setSourceDocStatus(sourceDocStatus);
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        return arTypeDTOList.get(0);
    }

    private ApTypeDTO selectApType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId, String ouCode) {
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode("YFD05_SYS");
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        return apTypeDTOList.get(0);
    }

    private String arSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO) {
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + "-" + invIoFinReceiptRpcDTO.getBuId() + "-" + invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + "-" + invIoFinReceiptRpcDTO.getCustId() + "-" + invIoFinReceiptRpcDTO.getCurrCode() + "--" + invIoFinReceiptRpcDTO.getSrcDocCls() + "-" + invIoFinReceiptRpcDTO.getSrcDocId() + "-" + invIoFinReceiptRpcDTO.getSrcDocNo() + "-" + invIoFinReceiptRpcDTO.getSceneCode();
        return spliceGroupKey;
    }

    private String apSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO) {
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + "-" + invIoFinReceiptRpcDTO.getBuId() + "-" + invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + "-" + invIoFinReceiptRpcDTO.getSuppId() + "-" + invIoFinReceiptRpcDTO.getIoCode() + "-" + invIoFinReceiptRpcDTO.getCurrCode() + "--" + invIoFinReceiptRpcDTO.getSrcDocCls() + "-" + invIoFinReceiptRpcDTO.getSrcDocId() + "-" + invIoFinReceiptRpcDTO.getSrcDocNo() + "-" + invIoFinReceiptRpcDTO.getSceneCode();
        return spliceGroupKey;
    }

    private List<SalDoDFinRespDTO> selectSalDodById(List<Long> srcDocDids) {
        if (CollectionUtil.isEmpty(srcDocDids)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
            return Collections.EMPTY_LIST;
        }
        SalDoDFinQueryDTO salDoDFinQueryDTO = new SalDoDFinQueryDTO();
        salDoDFinQueryDTO.setIds(srcDocDids);
        ApiResult apiResult = this.salDoDRpcService.queryDodByFinParam(salDoDFinQueryDTO);
        if (!apiResult.isSuccess()) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff1a" + apiResult.getMsg());
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff1a" + apiResult.getMsg());
        }
        List salDoDFinRespDTOList = (List)apiResult.getData();
        if (CollectionUtil.isEmpty((Collection)salDoDFinRespDTOList)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID :{}", srcDocDids);
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID: " + srcDocDids);
        }
        return salDoDFinRespDTOList;
    }

    private List<PurGrDRpcDTO> selectPurGrdById(List<Long> srcDocDids) {
        if (CollectionUtil.isEmpty(srcDocDids)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
            return Collections.EMPTY_LIST;
        }
        PurGrDParamRpcDTO purGrDParamRpcDTO = new PurGrDParamRpcDTO();
        purGrDParamRpcDTO.setIds(srcDocDids);
        List purGrDRpcDTOList = this.purGrDProvider.findGrdByParam(purGrDParamRpcDTO);
        if (CollectionUtil.isEmpty((Collection)purGrDRpcDTOList)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID :{}", srcDocDids);
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID: " + srcDocDids);
        }
        return purGrDRpcDTOList;
    }

    private List<InvTrnDRpcDTO> selectInvTrndById(List<Long> srcDocDids) {
        if (CollectionUtil.isEmpty(srcDocDids)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u5e93\u5b58(inv_trn_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
            return Collections.EMPTY_LIST;
        }
        InvTrnDRpcDtoParam invTrnDRpcDtoParam = new InvTrnDRpcDtoParam();
        invTrnDRpcDtoParam.setIds(srcDocDids);
        List invTrnDRpcDTOList = this.invTrnProvider.queryDodByParam(invTrnDRpcDtoParam);
        if (CollectionUtil.isEmpty((Collection)invTrnDRpcDTOList)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u5e93\u5b58(inv_trn_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID :{}", srcDocDids);
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u5e93\u5b58(inv_trn_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID: " + srcDocDids);
        }
        return invTrnDRpcDTOList;
    }

    private Map<String, String> selectCurrByCode(Set<String> currCodes) {
        if (CollectionUtil.isEmpty(currCodes)) {
            return new HashMap<String, String>();
        }
        List<SysCurrencyRespDTO> currencyRespDTOS = this.systemRpcService.findCurrByCodes(currCodes);
        if (CollectionUtil.isEmpty(currencyRespDTOS)) {
            return new HashMap<String, String>();
        }
        return currencyRespDTOS.stream().collect(Collectors.toMap(i -> i.getCurrCode(), i -> i.getCurrName(), (o, n) -> n));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApArOrderHandleDTO expenseLedgerCommit(ArOrder arOrder, ApOrder apOrder) {
        ApArOrderHandleDTO apArOrderHandleDTO = new ApArOrderHandleDTO();
        Long arResId = this.arOrderDomainService.newCommit(arOrder, false);
        apArOrderHandleDTO.setArResId(arResId);
        Long apResId = this.apOrderDomainService.newCommit(apOrder);
        apArOrderHandleDTO.setApResId(apResId);
        return apArOrderHandleDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoWriteoffByArId(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        this.finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoWriteoffByApId(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        this.finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApArOrderHandleDTO invInterTranCreateApArOrder(ApOrder apOrder, ArOrder arOrder) {
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode("YFD02_SYS");
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u914d\u7f6e(YFD02_SYS)");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219(YFD02_SYS)");
        }
        ApTypeDTO apTypeDTO = apTypeDTOList.get(0);
        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        apOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        apOrder.setSubmitTime(LocalDateTime.now());
        apOrder.setAuditDate(LocalDateTime.now());
        apOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        SysUserDTO apUser = this.systemRpcService.getUserByName("admin");
        apOrder.setAuditUserId(apUser.getId());
        apOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        apOrder.setApprovedTime(LocalDateTime.now());
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setArTypeCode("YSD02_SYS");
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.selectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u914d\u7f6e(YSD02_SYS)");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219(YSD02_SYS)");
        }
        ArTypeDTO arTypeDTO = arTypeDTOList.get(0);
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setSubmitTime(LocalDateTime.now());
        arOrder.setAuditDate(LocalDateTime.now());
        arOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        SysUserDTO arUser = this.systemRpcService.getUserByName("admin");
        arOrder.setAuditUserId(arUser.getId());
        arOrder.setApprovedTime(LocalDateTime.now());
        ApArOrderHandleDTO apArOrderDTO = new ApArOrderHandleDTO();
        Long arResId = this.arOrderDomainService.newCommit(arOrder, true);
        apArOrderDTO.setArResId(arResId);
        Long apResId = this.apOrderDomainService.newCommit(apOrder);
        apArOrderDTO.setApResId(apResId);
        ArOrderDTO newArOrderDTO = this.arOrderRepoProc.get(arResId);
        ApOrderDTO newApOrderDTO = this.apOrderRepoProc.get(apResId);
        apArOrderDTO.setArOrderNo(newArOrderDTO.getArOrderNo());
        apArOrderDTO.setApOrderNo(newApOrderDTO.getApOrderNo());
        this.arOrderDomainService.updateSourceNo(newApOrderDTO.getApOrderNo(), arResId);
        this.apOrderDomainService.updateSourceNo(newArOrderDTO.getArOrderNo(), apResId);
        CompletableFuture.runAsync(() -> {
            ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(arResId);
            this.finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
            this.updateArVerState(arResId);
        }, (Executor)this.taskExecutor);
        CompletableFuture.runAsync(() -> {
            ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(apResId);
            this.finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
            this.updateApVerState(apResId);
        }, (Executor)this.taskExecutor);
        return apArOrderDTO;
    }

    private void updateApVerState(Long id) {
        ApOrderDTO newApOrderDTO = this.apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> newApOrderDtlDTOList = this.apOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;
        BigDecimal verAmtingSum = BigDecimal.ZERO;
        BigDecimal unVerAmtSum = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(newApOrderDtlDTOList)) {
            for (ApOrderDtlDTO apOrderDtlDTO : newApOrderDtlDTOList) {
                if (null != apOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(apOrderDtlDTO.getVerAmt());
                }
                if (apOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(apOrderDtlDTO.getApplyVerAmTing());
                }
                if (apOrderDtlDTO.getUnVerAmt() == null) continue;
                unVerAmtSum = unVerAmtSum.add(apOrderDtlDTO.getUnVerAmt());
            }
        }
        String verState = null;
        verState = unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newApOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)verState)) {
            this.apOrderRepoProc.updateVerState(verState, id);
        }
    }

    private void updateArVerState(Long id) {
        ArOrderDTO newArOrderDTO = this.arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> newArOrderDtlDTOList = this.arOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;
        BigDecimal verAmtingSum = BigDecimal.ZERO;
        BigDecimal unVerAmtSum = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(newArOrderDtlDTOList)) {
            for (ArOrderDtlDTO arOrderDtlDTO : newArOrderDtlDTOList) {
                if (null != arOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(arOrderDtlDTO.getVerAmt());
                }
                if (arOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(arOrderDtlDTO.getApplyVerAmTing());
                }
                if (arOrderDtlDTO.getUnVerAmt() == null) continue;
                unVerAmtSum = unVerAmtSum.add(arOrderDtlDTO.getUnVerAmt());
            }
        }
        String verState = null;
        verState = unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newArOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)verState)) {
            this.arOrderRepoProc.updateVerState(verState, id);
        }
    }

    @Override
    public void refreshApOrderVerState(ApOrderRefreshParam param) {
        List<ApOrderDTO> unVerList = this.apOrderRepoProc.findUnVerIds(param);
        List split = CollUtil.split(unVerList, (int)100);
        for (List list : split) {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(trans -> {
                try {
                    List<Long> masIds = list.stream().map(ApOrderDTO::getId).collect(Collectors.toList());
                    List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(masIds);
                    Map apOrderDtlMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
                    for (ApOrderDTO apOrderDTO : list) {
                        BigDecimal verAmt = BigDecimal.ZERO;
                        BigDecimal verAmting = BigDecimal.ZERO;
                        BigDecimal unVerAmt = BigDecimal.ZERO;
                        String verState = apOrderDTO.getVerState();
                        List arOrderDtlDTOS1 = apOrderDtlMap.get(apOrderDTO.getId());
                        if (CollUtil.isNotEmpty(arOrderDtlDTOS1)) {
                            for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                                if (apOrderDtlDTO.getVerAmt() != null) {
                                    verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                                }
                                if (apOrderDtlDTO.getApplyVerAmTing() != null) {
                                    verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                                }
                                if (apOrderDtlDTO.getUnVerAmt() == null) continue;
                                unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                            }
                        }
                        verState = unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (unVerAmt.add(verAmting).compareTo(apOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                        this.apOrderRepoProc.updateVerState(verState, apOrderDTO.getId());
                    }
                }
                catch (Exception e) {
                    log.warn("\u5355\u636e\u66f4\u65b0\u6838\u9500\u72b6\u6001\u9519\u8bef\uff0c\u5c1d\u8bd5\u8bb0\u5f55\u9519\u8bef\u4fe1\u606f");
                    trans.setRollbackOnly();
                }
                return "OK";
            });
        }
    }

    public ApArOrderServiceImpl(InvStkProvider invStkProvider, ArTypeDomainService arTypeDomainService, ArTypeOuDomainService arTypeOuDomainService, ApTypeDomainService apTypeDomainService, ApTypeOuDomainService apTypeOuDomainService, TransactionTemplate transactionTemplate, SystemRpcService systemRpcService, ArOrderDomainService arOrderDomainService, ApOrderDomainService apOrderDomainService, SalDoDRpcService salDoDRpcService, PurGrDProvider purGrDProvider, InvTrnProvider invTrnProvider, PurSuppOutService purSuppOutService, RmiSaleRpcService rmiSaleRpcService, ArOrderRepoProc arOrderRepoProc, FinArRecVerApplyService finArRecVerApplyService, FinApPayVerApplyService finApPayVerApplyService, ApOrderRepoProc apOrderRepoProc, TaskExecutor taskExecutor, ApOrderDtlRepoProc apOrderDtlRepoProc, ArOrderDtlRepoProc arOrderDtlRepoProc) {
        this.invStkProvider = invStkProvider;
        this.arTypeDomainService = arTypeDomainService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.apTypeDomainService = apTypeDomainService;
        this.apTypeOuDomainService = apTypeOuDomainService;
        this.transactionTemplate = transactionTemplate;
        this.systemRpcService = systemRpcService;
        this.arOrderDomainService = arOrderDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.salDoDRpcService = salDoDRpcService;
        this.purGrDProvider = purGrDProvider;
        this.invTrnProvider = invTrnProvider;
        this.purSuppOutService = purSuppOutService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.arOrderRepoProc = arOrderRepoProc;
        this.finArRecVerApplyService = finArRecVerApplyService;
        this.finApPayVerApplyService = finApPayVerApplyService;
        this.apOrderRepoProc = apOrderRepoProc;
        this.taskExecutor = taskExecutor;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
    }
}

