package com.elitesland.fin.application.facade.param.recorder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/15 13:32
 */
@Data
public class RecOrderDtlSaveParam implements Serializable {

    private static final long serialVersionUID = 78799470814510082L;
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("收款方式")
    private String recType;
    private String recTypeName;

    @ApiModelProperty("收款类型")
    private String recKind;

    @ApiModelProperty("收款银行名称")
    private String recBank;

    @ApiModelProperty("收款银行账户")
    private String recAccount;

    @ApiModelProperty("收款流水")
    private String recFlow;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    private String expensesType;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;
    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;
    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("付款银行账户")
    private String es16;

    @ApiModelProperty("付款银行账户")
    private String es17;
}
