package com.elitesland.fin.application.service.payorder;


import com.elitesland.fin.application.convert.payorder.PayOrderDtlConvert;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author zhiyu.he
 * @date 2022/3/16 13:04
 */
@Service
@RequiredArgsConstructor
public class PayOrderDtlServiceImpl implements PayOrderDtlService {

    private final PayOrderDtlDomainService payOrderDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<PayOrderDtlVO> page(PayOrderDtlPageParam param) {
        PagingVO<PayOrderDtlDTO> page = payOrderDtlDomainService.page(param);
        PagingVO<PayOrderDtlVO> pagingVO = PayOrderDtlConvert.INSTANCE.convertPage(page);
        return pagingVO;
    }
}
