package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFastCodeVO;
import com.elitesland.fin.application.service.accountingengine.FinFastCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/fast/code")
@RequiredArgsConstructor
@Api(value = "快码", tags = {"快码"})
public class FinFastCodeController {

    private final FinFastCodeService finFastCodeService;

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinFastCodeParam finFastCodeParam) {

        return ApiResult.ok(finFastCodeService.saveOrUpdate(finFastCodeParam));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinFastCodeVO>> page(@RequestBody FinFastCodeParam finFastCodeParam) {
        return ApiResult.ok(finFastCodeService.page(finFastCodeParam));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinFastCodeParam finFastCodeParam) {
        finFastCodeService.enableOrDisable(finFastCodeParam);
        return ApiResult.ok();
    }


}
