package com.elitesland.fin.rpc.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.param.*;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.order.service.SaleReconciliatRpcService;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class RmiOrderRpcServiceImpl implements RmiOrderRpcService {

//    private final TsSalSoRpcService tsSalSoRpcService;

    private final SaleReconciliatRpcService saleReconciliatRpcService;
    private final SalDoRpcService salDoRpcService;

    @Override
    public ApiResult<Long> orderAccountFlow() {

//        ApiResult<Long> apiResult=tsSalSoRpcService.orderAccountFlow(orderAccountFlowRpcParam);
//        Assert.notNull(apiResult,"返回订单流水信息失败");
//        Assert.isTrue(apiResult.isSuccess(),"返回订单流水信息失败");
//        return apiResult;
        return null;
    }

    @Override
    public List<SaleReconciliatDTO> querySalReconciliat(SalReconciliatQueryDTO salReconciliatQueryDTO) {

        ApiResult<List<SaleReconciliatDTO>> apiResult = saleReconciliatRpcService.querySalReconciliat(salReconciliatQueryDTO);
        Assert.notNull(apiResult, "查询对账单失败,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "查询对账单失败");
        return apiResult.getData();

    }

    @Override
    public Long updateTransState(SalReconciliatQueryDTO salReconciliatQueryDTO) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateTransState(salReconciliatQueryDTO);
        Assert.notNull(apiResult, "更新对账单明细传输状态失败,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新对账单明细传输状态失败");
        return apiResult.getData();

    }

    @Override
    public Long updateInvingState(List<SalReconciliatInvDTO> saleInvDTOList) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateInvingState(saleInvDTOList);
        Assert.notNull(apiResult, "更新开票状态为开票中,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新开票状态为开票中失败");
        return apiResult.getData();
    }


    @Override
    public Long updateInvedState(SaleReconciliatDTO saleInvDTO) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateInvedState(saleInvDTO);
        Assert.notNull(apiResult, "更新开票状态为开票中,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新开票状态为开票中失败");
        return apiResult.getData();
    }

    /**
     * 查询销售发货和退货入库信息接口
     *
     * @param docNos 关联单编号
     * @return
     */
    @Override
    public List<SalDoRespDTO> findSalDoByParam(List<String> docNos) {
        if (CollectionUtil.isEmpty(docNos)) {
            return Collections.EMPTY_LIST;
        }
        try {
            SalDoQueryDTO salDoQueryDTO = new SalDoQueryDTO();
            salDoQueryDTO.setDocNos(docNos);
            ApiResult<List<SalDoRespDTO>> apiResult = salDoRpcService.findSimpleRpcDtoByParam(salDoQueryDTO);
            if (apiResult.isSuccess()) {
                List<SalDoRespDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用订单域(findSalDoByParam)查询销售发货或退货入库失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findSalDoByParam error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用订单中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,SalDoRespDTO> findSalDoMapByCodes(List<String> relateDoc2NoList) {

        List<SalDoRespDTO> rpcDTOList = this.findSalDoByParam(relateDoc2NoList);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, SalDoRespDTO> rpcDTOMap = rpcDTOList.stream().collect(Collectors.toMap(SalDoRespDTO::getDocNo, t -> t, (t1, t2) -> t1));

        return rpcDTOMap;

    }
}
