package com.elitesland.fin.application.facade.dto.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计期间控制")
public class FinSobAccountPeriodDTO extends BaseModelDTO {

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("期间格式")
    private String periodStyle;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("起始日期")
    private LocalDateTime activeStartTime;

    @ApiModelProperty("结束日期")
    private LocalDateTime activeEndTime;
}
