package com.elitesland.fin.application.facade.vo.account;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 账户储值vo
 * @Date 2023/5/18
 */
@Data
@ApiModel("账户储值")
public class AccountStorageVO extends BaseViewModel {

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-fin", mod = "STORED_ORDER_TYPE")
    private String receiptType;
    private String receiptTypeName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "RECORDER_STATE")
    private String receiptStatus;
    private String receiptStatusName;

    @ApiModelProperty("归属公司")
    private String company;

    @ApiModelProperty("归属加盟商")
    private String franchisee;
    @ApiModelProperty("归属加盟商名称")
    private String franchiseeName;

    private Long ouId;

    @ApiModelProperty("收款公司")
    private String ouName;

    @ApiModelProperty("收款账户名称")
    private String accName;

    @ApiModelProperty("收款账号编码")
    private String accCode;

    @ApiModelProperty("汇款主体名称")
    private String remitter;

    @ApiModelProperty("汇款银行编码")
    private String remitterBankCode;

    @ApiModelProperty("汇款银行名称")
    private String remitterBankName;

    @ApiModelProperty("汇款账号")
    private String remitterAccount;

    @ApiModelProperty("汇款金额")
    private BigDecimal remitterAmt;

    @ApiModelProperty("汇款日期")
    private LocalDate remitterDate;

    @ApiModelProperty("支付方式")
    @SysCode(sys = "yst-fin", mod = "PAY_METHOD")
    private String payMode;
    private String payModeName;

    @ApiModelProperty("审核人")
    private String checker;

    @ApiModelProperty("审核时间")
    private LocalDateTime checkTime;

    @ApiModelProperty("支付流水号")
    private String payOrderId;

    @ApiModelProperty("支付信息")
    private String payMessage;

    /**
     * 银联商务返回的摘要信息
     */
    @ApiModelProperty("银行返回摘要")
    private String abstractInfo;

    @ApiModelProperty("银行返回原始报文")
    private String oriMsg;

    private String state;

    @ApiModelProperty("支付凭证")
    private String applyFile;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

    public String getOuName() {
        if (StrUtil.isBlank(ouName)) {

            return secOuName;
        } else {
            return ouName;
        }
    }
}
