package com.elitesland.fin.application.service.financial;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDPageParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillDVO;
import com.elitesland.fin.domain.service.financial.FinancialBillDDomainService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author zhiyu.he
 * @date 2025/10/14 14:56
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FinancialBillDServiceImpl implements FinancialBillDService{

    private final FinancialBillDDomainService financialBillDomainService;
    @SysCodeProc
    @Override
    public PagingVO<FinancialBillDVO> pageSearch(FinancialBillDPageParam financialBillPageParam) {
        return FinancialBillDConvert.INSTANCE.convertPage(financialBillDomainService.page(financialBillPageParam));
    }
}
