package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyArConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyArServiceImpl implements FinArRecVerApplyArService {

    private final FinArRecVerApplyArRepoProc finArRecVerApplyArRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ArOrderRepoProc arOrderRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplyArSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }

        List<String> arDocNoList = saveList.stream().map(FinArRecVerApplyArSaveDTO::getArDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArOrderDTO> arOrderDTOList = arOrderRepoProc.selectInOutCustByArOrderNo(arDocNoList);
        Map<String, ArOrderDTO> arOrderMap = CollectionUtil.isEmpty(arOrderDTOList) ? new HashMap<>() : arOrderDTOList.stream().collect(Collectors.toMap(ArOrderDTO::getArOrderNo, t -> t, (t1, t2) -> t1));


        finArRecVerApplyArRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplyArDO entity = FinArRecVerApplyArConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);

                    ArOrderDTO arOrderDTO = arOrderMap.get(entity.getArDocNo());
                    if (Objects.nonNull(arOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? arOrderDTO.getInOutCust() : entity.getInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? arOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                        entity.setInOutCust(inOutCust);
                        entity.setRelevanceOuCode(relevanceOuCode);
                    }
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyArRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinArRecVerApplyArVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = finArRecVerApplyArRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finArRecVerApplyArVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyArVOList.stream().map(FinArRecVerApplyArVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyArVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finArRecVerApplyArVOList;
    }

	/**
	 * 根据条件查询核销应收单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyArVO> listByQuery(FinArRecVerApplyArQuery query) {
		return finArRecVerApplyArRepoProc.listByQuery(query)
				.stream()
				.map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyArVO> listByOutArDocNoOrDId(FinArRecVerApplyQuery applyQuery) {
	/*	if(StrUtil.isEmpty(applyQuery.getOutArDocNo()) && StrUtil.isEmpty(applyQuery.getOutArDId())){
			return null;
		}*/
		return finArRecVerApplyArRepoProc.listByOutArDocNoOrDId(applyQuery);
	}
}
