package com.elitesland.fin.domain.service.financial;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import com.elitesland.fin.repo.financial.FinancialBillDRepo;
import com.elitesland.fin.repo.financial.FinancialBillDRepoProc;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Mark
 * @date 2024/08/13 18:23
 */
@Service
@AllArgsConstructor
public class FinancialBillDDomainServiceImpl implements FinancialBillDDomainService {

    private final FinancialBillDRepoProc financialBillRepoProc;
    private final FinancialBillDRepo financialBillRepo;
    @Override
    public PagingVO<FinancialBillDDTO> page(FinancialBillDPageParam financialBillPageParam) {
        return financialBillRepoProc.page(financialBillPageParam);
    }

    @Override
    public List<FinancialBillDDTO> queryByMasId(Long id) {
        List<FinancialBillDDO> byMasId = financialBillRepo.findByMasId(id);
        return FinancialBillDConvert.INSTANCE.doToDto(byMasId);
    }

    @Override
    public List<FinancialBillDDTO> queryByMasIdIn(List<Long> masId) {
        List<FinancialBillDDO> byMasId = financialBillRepo.findByMasIdIn(masId);
        return FinancialBillDConvert.INSTANCE.doToDto(byMasId);
    }

    @Override
    public void batchSaveFinancialBillD(List<FinancialBillDDO> param) {
        financialBillRepo.saveAll(param);
    }
}