package com.elitesland.fin.domain.service.financial;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.domain.base.BaseRepo;
import com.elitesland.fin.domain.service.expense.ExpRuleConfigDtlDomainService;
import com.elitesland.fin.entity.expense.ExpRuleConfigDtlDO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepoProc;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Mark
 * @date 2024/08/13 18:23
 */
@Service
@AllArgsConstructor
public class FinancialBillDomainServiceImpl implements FinancialBillDomainService {

    private final FinancialBillRepoProc financialBillRepoProc;
    private final FinancialBillRepo financialBillRepo;
    @Override
    public PagingVO<FinancialBillDTO> page(FinancialBillPageParam financialBillPageParam) {
        return financialBillRepoProc.page(financialBillPageParam);
    }

    @Override
    public FinancialBillDTO get(Long id) {
        return FinancialBillConvert.INSTANCE.doToDto(financialBillRepo.findById(id).get());
    }

    @Transactional
    @Override
    public Long save(FinancialBillDO financialBillDO) {
        return financialBillRepo.save(financialBillDO).getId();
    }
}