package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleValueDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFlexibleDO;
import com.elitesland.fin.dto.accountingengine.FinFlexibleValueCheckItemRpcDTO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinFlexibleRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;

    private final QFinFlexibleDO qFinFlexibleDO = QFinFlexibleDO.finFlexibleDO;

    public PagingVO<FinFlexibleDTO> page(FinFlexibleParam finFlexibleParam) {
        Predicate where = where(finFlexibleParam);
        JPAQuery<FinFlexibleDTO> query = select(FinFlexibleDTO.class).where(ExpressionUtils.allOf(where));
        finFlexibleParam.setPaging(query);
        finFlexibleParam.fillOrders(query, qFinFlexibleDO);

        List<FinFlexibleDTO> finFlexibleDTOList = query.fetch();

        List<Long> ids = finFlexibleDTOList.stream().map(FinFlexibleDTO::getId).collect(Collectors.toList());
        List<FinFlexibleValueDTO> finFlexibleValueDOList = FinFlexibleValueConvert.INSTANCE.DOToDTO(finFlexibleValueRepo.findAllByMasIdIn(ids));

        //过滤明细
        if (finFlexibleParam.getDescendantsFlag() != null) {
            finFlexibleValueDOList = finFlexibleValueDOList.stream()
                    .filter(item -> finFlexibleParam.getDescendantsFlag().equals(item.getDescendantsFlag()))
                    .collect(Collectors.toList());
        }
        for (FinFlexibleDTO finFlexibleDTO : finFlexibleDTOList) {
            //值集明细按值集编码排序
            List<FinFlexibleValueDTO> flexibleValueDTOS = finFlexibleValueDOList.stream()
                    .filter(finFlexibleValueDO -> finFlexibleDTO.getId().equals(finFlexibleValueDO.getMasId()))
                    .collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(flexibleValueDTOS)){
                flexibleValueDTOS=flexibleValueDTOS.stream().sorted(new Comparator<FinFlexibleValueDTO>() {
                    @Override
                    public int compare(FinFlexibleValueDTO o1, FinFlexibleValueDTO o2) {
                        return o1.getFlexibleValueCode().compareTo(o2.getFlexibleValueCode());
                    }
                }).collect(Collectors.toList());

                flexibleValueDTOS.forEach(item -> {
                    if(StringUtils.isNotEmpty(item.getCheckitementry())){
                        item.setCheckItemList(JSON.parseArray(item.getCheckitementry(), FinFlexibleValueCheckItemRpcDTO.class));
                    }
                });

                finFlexibleDTO.setDetailList(flexibleValueDTOS);
            }
        }
        return PagingVO.<FinFlexibleDTO>builder()
                .total(query.fetchCount())
                .records(finFlexibleDTOList)
                .build();
    }

    private Predicate where(FinFlexibleParam finFlexibleParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finFlexibleParam.getId() != null, qFinFlexibleDO.id, finFlexibleParam.getId())
                .andLike(StringUtils.isNotEmpty(finFlexibleParam.getFlexibleCode()), qFinFlexibleDO.flexibleCode, StringUtil.buildLikeString(finFlexibleParam.getFlexibleCode()))
                .andLike(StringUtils.isNotEmpty(finFlexibleParam.getFlexibleName()), qFinFlexibleDO.flexibleName, StringUtil.buildLikeString(finFlexibleParam.getFlexibleName()))
                .andEq(StringUtils.isNotEmpty(finFlexibleParam.getFlexibleType()), qFinFlexibleDO.flexibleType, finFlexibleParam.getFlexibleType())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinFlexibleDO.id,
                qFinFlexibleDO.flexibleCode,
                qFinFlexibleDO.flexibleName,
                qFinFlexibleDO.flexibleType,
                qFinFlexibleDO.parentFlexibleCode,
                qFinFlexibleDO.parentFlexibleName,
                qFinFlexibleDO.status,

                qFinFlexibleDO.createTime,
                qFinFlexibleDO.creator,
                qFinFlexibleDO.modifyTime,
                qFinFlexibleDO.updater
        )).from(qFinFlexibleDO);
    }


    public FinFlexibleDO findByFlexibleCode(String flexibleCode) {

        List<FinFlexibleDO> finFlexibleDOList = finFlexibleRepo.findAllByFlexibleCode(flexibleCode);

        if (CollectionUtils.isNotEmpty(finFlexibleDOList)) {
            Assert.equals(finFlexibleDOList.size(), 1, "查询到多条值集");
            return finFlexibleDOList.get(0);
        }
        return null;
    }

    public List<FinFlexibleDO> findAllByFlexibleCodeIn(List<String> flexibleCodes) {

        if(CollectionUtils.isEmpty(flexibleCodes)){
            return Collections.emptyList();
        }

        List<FinFlexibleDO> finFlexibleDOList = finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        Assert.notEmpty(finFlexibleDOList,"查不到值集");

        return finFlexibleDOList;
    }

    public List<FinFlexibleDO> findAllByFlexibleCodeInAndStatus(List<String> flexibleCodes,String status) {

        if(CollectionUtils.isEmpty(flexibleCodes)){
            return Collections.emptyList();
        }

        List<FinFlexibleDO> finFlexibleDOList = finFlexibleRepo.findAllByFlexibleCodeInAndStatus(flexibleCodes,status);
        Assert.notEmpty(finFlexibleDOList,"查不到值集");

        return finFlexibleDOList;
    }





}
