/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.utils.TimeUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleInvRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;

    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam, List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != saleInvPageParam.getOuId()) {
            predicates.add(this.qSaleInvDO.ouId.eq((Object)saleInvPageParam.getOuId()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getCreateMode())) {
            predicates.add(this.qSaleInvDO.createMode.eq((Object)saleInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getApplyNo())) {
            predicates.add(this.qSaleInvDO.invRegNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getSourceSysNo())) {
            predicates.add(this.qSaleInvDO.sourceSysNo.eq((Object)saleInvPageParam.getSourceSysNo()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getCustName())) {
            predicates.add(this.qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add(this.qSaleInvDO.custId.eq((Object)saleInvPageParam.getCustId()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add(this.qSaleInvDO.custCode.eq((Object)saleInvPageParam.getCustCode()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInvType())) {
            predicates.add(this.qSaleInvDO.invType.eq((Object)saleInvPageParam.getInvType()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInfoNo())) {
            predicates.add(this.qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getExpressNo())) {
            predicates.add(this.qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getDocType3())) {
            predicates.add(this.qSaleInvDO.docType3.eq((Object)saleInvPageParam.getDocType3()));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(this.qSaleInvDO.id.in(ids));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRecvContactName())) {
            predicates.add(this.qSaleInvDO.recvContactName.like("%" + saleInvPageParam.getRecvContactName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRecvContactTel())) {
            predicates.add(this.qSaleInvDO.recvContactTel.like("%" + saleInvPageParam.getRecvContactTel() + "%"));
        }
        predicates.add(this.qSaleInvDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(SaleInvDTO.class).where(ExpressionUtils.allOf(predicates));
        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, this.qSaleInvDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qSaleInvDO.id, this.qSaleInvDO.createTime, this.qSaleInvDO.updater, this.qSaleInvDO.modifyTime, this.qSaleInvDO.creator, this.qSaleInvDO.remark, this.qSaleInvDO.sourceSysNo, this.qSaleInvDO.applyNo, this.qSaleInvDO.ouCode, this.qSaleInvDO.ouId, this.qSaleInvDO.ouName, this.qSaleInvDO.taxRate, this.qSaleInvDO.invRegNo, this.qSaleInvDO.currCode, this.qSaleInvDO.currName, this.qSaleInvDO.localCurrCode, this.qSaleInvDO.localCurrName, this.qSaleInvDO.totalAmt, this.qSaleInvDO.totalCurAmt, this.qSaleInvDO.saleInvTitle, this.qSaleInvDO.saleTaxNo, this.qSaleInvDO.saleTel, this.qSaleInvDO.saleAdd, this.qSaleInvDO.saleBank, this.qSaleInvDO.saleBankAcc, this.qSaleInvDO.saleRemark, this.qSaleInvDO.saleId, this.qSaleInvDO.saleName, this.qSaleInvDO.saleCode, this.qSaleInvDO.custInvTitle, this.qSaleInvDO.custTaxNo, this.qSaleInvDO.custAdd, this.qSaleInvDO.custTel, this.qSaleInvDO.custBank, this.qSaleInvDO.custBankAcc, this.qSaleInvDO.custRemark, this.qSaleInvDO.custId, this.qSaleInvDO.custName, this.qSaleInvDO.custCode, this.qSaleInvDO.invUser, this.qSaleInvDO.recUser, this.qSaleInvDO.revUser, this.qSaleInvDO.auditUserId, this.qSaleInvDO.pushMethod, this.qSaleInvDO.phone, this.qSaleInvDO.email, this.qSaleInvDO.infoNo, this.qSaleInvDO.expressNo, this.qSaleInvDO.invState, this.qSaleInvDO.auditUser, this.qSaleInvDO.auditDate, this.qSaleInvDO.orderState, this.qSaleInvDO.exchangeRate, this.qSaleInvDO.auditRejection, this.qSaleInvDO.createMode, this.qSaleInvDO.invType, this.qSaleInvDO.procInstId, this.qSaleInvDO.procInstStatus, this.qSaleInvDO.approvedTime, this.qSaleInvDO.submitTime, this.qSaleInvDO.mainCustName, this.qSaleInvDO.mainCustCode, this.qSaleInvDO.mainCustId, this.qSaleInvDO.invMerge, this.qSaleInvDO.invCustCode, this.qSaleInvDO.invCustId, this.qSaleInvDO.invCustName, this.qSaleInvDO.docType3, this.qSaleInvDO.recvContactName, this.qSaleInvDO.recvContactTel})).from((EntityPath)this.qSaleInvDO);
    }

    public SaleInvDTO get(Long id) {
        SaleInvDTO saleInvDTO = (SaleInvDTO)((JPAQuery)this.select(SaleInvDTO.class).where((Predicate)this.qSaleInvDO.id.eq((Object)id))).fetchOne();
        return saleInvDTO;
    }

    public Long del(List<Long> ids) {
        long res = this.jpaQueryFactory.delete((EntityPath)this.qSaleInvDO).where(new Predicate[]{this.qSaleInvDO.id.in(ids)}).execute();
        return res;
    }

    public Long updateInvInfo(SaleInvParam saleInvParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.remark, (Object)saleInvParam.getRemark()).set((Path)this.qSaleInvDO.expressNo, (Object)saleInvParam.getExpressNo()).set((Path)this.qSaleInvDO.infoNo, (Object)saleInvParam.getInfoNo()).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)saleInvParam.getId())}).execute();
        return res;
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qSaleInvDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qSaleInvDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)this.qSaleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        jpaUpdateClause.execute();
    }

    public void deleteById(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set(this.qSaleInvDO.deleteFlag, (Object)1).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void updateArFlagByApplyNo(String applyNo, Boolean arFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.arFlag, (Object)arFlag).where(new Predicate[]{this.qSaleInvDO.applyNo.eq((Object)applyNo)}).execute();
    }

    public Long updateOrderStateAndDrawDate(SaleInvParam saleInvParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.orderState, (Object)saleInvParam.getOrderState()).set(this.qSaleInvDO.drawDate, (Object)saleInvParam.getDrawDate()).where(new Predicate[]{this.qSaleInvDO.applyNo.eq((Object)saleInvParam.getApplyNo())}).execute();
        return res;
    }

    public Long updateOrderStateAndRedPunchDate(SaleInvParam saleInvParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.orderState, (Object)saleInvParam.getOrderState()).set(this.qSaleInvDO.redPunchDate, (Object)saleInvParam.getRedPunchDate()).where(new Predicate[]{this.qSaleInvDO.applyNo.eq((Object)saleInvParam.getApplyNo())}).execute();
        return res;
    }

    public Long updateOrderStateAndRedPunchDate(String orderState, LocalDateTime redPunchDate, Long id) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.orderState, (Object)orderState).set(this.qSaleInvDO.redPunchDate, (Object)redPunchDate).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)id)}).execute();
        return res;
    }

    public SaleInvVO queryAmt() {
        SaleInvVO saleInvVO = new SaleInvVO();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastOfYear = TimeUtil.getLastOfYear(now);
        LocalDateTime firstOfYear = TimeUtil.getFirstOfYear(now);
        BigDecimal redAmt = (BigDecimal)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qSaleInvDO.totalAmt.sum()).from((EntityPath)this.qSaleInvDO)).where((Predicate)this.qSaleInvDO.drawDate.between((Comparable)firstOfYear, (Comparable)lastOfYear).and((Predicate)this.qSaleInvDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_RED_SUCCESS.getValueCode())))).fetchOne();
        BigDecimal successAmt = (BigDecimal)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qSaleInvDO.totalAmt.sum()).from((EntityPath)this.qSaleInvDO)).where((Predicate)this.qSaleInvDO.redPunchDate.between((Comparable)firstOfYear, (Comparable)lastOfYear).and((Predicate)this.qSaleInvDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_INV_SUCCESS.getValueCode())))).fetchOne();
        saleInvVO.setRedAmt(ObjectUtil.isNotNull((Object)redAmt) ? redAmt : BigDecimal.ZERO);
        saleInvVO.setSuccessAmt(ObjectUtil.isNotNull((Object)successAmt) ? successAmt : BigDecimal.ZERO);
        BigDecimal sub = saleInvVO.getSuccessAmt().subtract(saleInvVO.getRedAmt());
        BigDecimal divide = ObjectUtil.equals((Object)sub, (Object)BigDecimal.ZERO) ? BigDecimal.ONE : saleInvVO.getRedAmt().divide(sub, 8, RoundingMode.HALF_UP);
        saleInvVO.setRate(divide);
        saleInvVO.setHasRemind(divide.compareTo(new BigDecimal(0.1)) > 0);
        return saleInvVO;
    }

    public SaleInvRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

