package com.elitesland.fin.application.facade.excel.adjust;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class CreditAdjustOrderImportEntity implements Serializable {

    private static final long serialVersionUID = 6516605491117978659L;

    @ApiModelProperty("授信类型名称")
    @ExcelProperty(index = 0)
    private String creditTypeName;

    @ApiModelProperty("调整类型")
    @ExcelProperty(index = 1)
    private String adjustTypeName;

    @ApiModelProperty("效期起")
    @ExcelProperty(index = 2)
    private String effectiveTime;

    @ApiModelProperty("效期至")
    @ExcelProperty(index = 3)
    private String expireTime;

    @ExcelProperty(index = 4)
    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ExcelProperty(index = 5)
    @ApiModelProperty("调整额度")
    private String adjustLimit;

    @ApiModelProperty("调整原因")
    @ExcelProperty(index = 6)
    private String adjustReasonName;

    @ExcelProperty(index = 7)
    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

}
