package com.elitesland.fin.application.facade.param.expense;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author Mark
 * @date 2024/08/13 14:23
 */
@Data
@ApiModel("分页查询账户规则")
public class ExpLedgerQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("物流公司")
    private String carrier;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("来源单号")
    private String sourceDocNo;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("计算状态")
    private String calState;

    @ApiModelProperty("来源单据日期")
    private LocalDate sourceDocNoDateStart;

    @ApiModelProperty("来源单据日期")
    private LocalDate sourceDocNoDateEnd;

    @ApiModelProperty("费用类型编码")
    private String expTypeCode;

    @ApiModelProperty("生成财务单据标识 0-未生成；1-已生成；2-生成失败")
    private String finFlag;

    @ApiModelProperty("未生成财务单据标识")
    private Boolean notGenerateFinFlag;
}
