package com.elitesland.fin.application.facade.vo.arorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/13 13:11
 */
@Data
public class ArAgingReportDtlVO implements Serializable {

    private static final long serialVersionUID = -6375116976664134791L;
    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("应收单编号")
    private String arOrderNo;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("起算日期")
    private LocalDateTime es23;

    @ApiModelProperty("到期付款日")
    private LocalDateTime es24;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("含税金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("账期标识")
    List<Integer> agingFlags;

}
