package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeLineConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeLineParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFastCodeVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinFastCodeServiceImpl implements FinFastCodeService {


    private final FinFastCodeRepo finFastCodeRepo;

    private final FinFastCodeRepoProc finFastCodeRepoProc;

    private final FinFastCodeLineRepo finFastCodeLineRepo;


    @SysCodeProc
    @Override
    public PagingVO<FinFastCodeVO> page(FinFastCodeParam finFastCodeParam) {
        return FinFastCodeConvert.INSTANCE.DTOToVO(finFastCodeRepoProc.page(finFastCodeParam));
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void enableOrDisable(FinFastCodeParam finFastCodeParam) {

        checkEnableOrDisableParam(finFastCodeParam);

        List<FinFastCodeDO> finFastCodeDOList = finFastCodeRepo.findAllById(finFastCodeParam.getIds());
        finFastCodeDOList.stream().forEach(item -> Assert.isFalse(finFastCodeParam.getStatus().equals(item.getStatus()), "数据已经启用/禁用"));

        finFastCodeDOList.stream().forEach(item -> item.setStatus(finFastCodeParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinFastCodeParam finFastCodeParam) {
        Assert.notEmpty(finFastCodeParam.getIds(), "id必填");
        Assert.notEmpty(finFastCodeParam.getStatus(), "状态必填");
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long saveOrUpdate(FinFastCodeParam finFastCodeParam) {

        checkSaveOrUpdateParam(finFastCodeParam);

        checkIdempotent(finFastCodeParam);

        FinFastCodeDO finFastCodeDO = finFastCodeRepo.save(FinFastCodeConvert.INSTANCE.paramToDO(finFastCodeParam));
        finFastCodeLineRepo.deleteAllByMasId(finFastCodeDO.getId());

        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();
        finFastCodeLineParamList.stream().forEach(item -> item.setMasId(finFastCodeDO.getId()));
        finFastCodeLineRepo.saveAll(FinFastCodeLineConvert.INSTANCE.paramToDO(finFastCodeLineParamList));

        return finFastCodeDO.getId();
    }

    private void checkSaveOrUpdateParam(FinFastCodeParam finFastCodeParam) {
        Assert.notEmpty(finFastCodeParam.getFastCode(), "快码编码必填");
        Assert.notEmpty(finFastCodeParam.getFastName(), "快码名称必填");
        Assert.notEmpty(finFastCodeParam.getStatus(), "状态必填");

        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();
        Assert.notEmpty(finFastCodeLineParamList, "快码明细必填");

    }

    private void checkIdempotent(FinFastCodeParam finFastCodeParam) {

        FinFastCodeDO finFastCodeDO = finFastCodeRepoProc.findByFastCode(finFastCodeParam.getFastCode());

        if (finFastCodeDO != null) {
            Assert.equals(finFastCodeParam.getId(), finFastCodeDO.getId(), "快码编码已经存在");
        }

        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();

        Set<String> uniqueFields = new HashSet<>();

        finFastCodeLineParamList.stream().forEach(item -> {
            String uniqueField = buildUniqueField(item);
            Assert.isFalse(uniqueFields.contains(uniqueField), "条件123字段条件123字段值重复");
            uniqueFields.add(uniqueField);
        });
    }


    private String buildUniqueField(FinFastCodeLineParam finFastCodeLineParam) {
        return finFastCodeLineParam.getConditionOne() + finFastCodeLineParam.getConditionOneValue() +
                finFastCodeLineParam.getConditionTwo() + finFastCodeLineParam.getConditionTwoValue() +
                finFastCodeLineParam.getConditionThree() + finFastCodeLineParam.getConditionThreeValue();
    }
}
