package com.elitesland.fin.application.service.arorder;

import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.application.facade.param.arorder.ApOrderRefreshParam;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/27
 * @Version 1.0
 * @Content:
 */
public interface ApArOrderService {


    /**
     * 逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)
     *
     * @param param 入参
     * @return 出参
     */
    void logicInvIoJobAutoCreateApArOrder(String param);

    void logicInvIoCreateApArOrder(ApArOrderParam param);


    ApArOrderHandleDTO expenseLedgerCommit(ArOrder arOrder, ApOrder apOrder);

    void autoWriteoffByArId(Long id);

    void autoWriteoffByApId(Long id);

    /**
     * 公司间事务账单生成应收应付单据(应收单与应付单)
     *
     * @param apOrder 入参
     * @param arOrder 入参
     * @return 出参
     */
    ApArOrderHandleDTO invInterTranCreateApArOrder(ApOrder apOrder,ArOrder arOrder);

    /**
     * 刷新应付单核销状态
     */
    void refreshApOrderVerState(ApOrderRefreshParam param);

}
