package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPayHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayHeadDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepo;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyPayHeadServiceImpl implements FinApPayVerApplyPayHeadService {

    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;

    private final FinApPayVerApplyPayHeadRepo finApPayVerApplyPayHeadRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;


    @Override
    public Long create(Long masId, FinApPayVerApplyPayHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinApPayVerApplyPayHeadDO entity = FinApPayVerApplyPayHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);

        if (StringUtils.isBlank(entity.getInOutCust()) || StringUtils.isBlank(entity.getRelevanceOuCode())){
            List<PayOrderDTO> payOrderDTOList = payOrderRepoProc.selectInOutCustByPayOrderNo(Collections.singletonList(entity.getPayOrderNo()));
            Map<String, PayOrderDTO> payOrderMap = CollectionUtil.isEmpty(payOrderDTOList) ? new HashMap<>() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1));
            PayOrderDTO payOrderDTO = payOrderMap.get(entity.getPayOrderNo());
            if (Objects.nonNull(payOrderDTO)){
                String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? payOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
        }

        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AP_PAY_VER_APPLY_PAY_HEAD, entity);
        return finApPayVerApplyPayHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyPayHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyPayHeadVO> finApPayVerApplyPayHeadVOList = finApPayVerApplyPayHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finApPayVerApplyPayHeadVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyPayHeadVOList.stream().map(FinApPayVerApplyPayHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyPayHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finApPayVerApplyPayHeadVOList;
    }

	@Override
	public List<FinApPayVerApplyPayHeadVO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {
		return finApPayVerApplyPayHeadRepoProc.listByIds(query,ids)
				.stream()
				.map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
