package com.elitesland.fin.domain.service.payorder;

import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;


/**
 * @author zhiyu.he
 * @date 2022/3/16 9:53
 */
public interface PayOrderDtlDomainService {

    /**
     * 根据付款单ID分页查询明细信息
     * @param param
     * @return
     */
    PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param);

    /**
     * 根据主键ID查询数据
     * @param ids 主键ID
     * @return 明细表数据
     */
    List<PayOrderDtlDTO> queryById(List<Long> ids);

    /**
     * 根据总单ID查询数据
     *
     * @param masIds 总单ID集合
     * @return 明细表数据
     */
    List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds);

    /**
     * 查询应付单关联的草稿状态的付款单明细行
     * @param sourceIdList
     * @return
     */
    List<PayOrderDtlDTO> queryBySourceIdList(List<Long> sourceIdList);

    /**
     * 回写单据核销金额，更新核销状态
     *
     * @param payDIdVerAmtMap
     * @param payDIds
     */
    void updateVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds);

    /**
     * 将审批取消的核销金额，从明细减去，还原核销状态
     *
     * @param payDIdVerAmtMap
     * @param payDIds
     */
    void resortVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds);
}
