package com.elitesland.fin.infr.dto.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.dto.arorder
 * @date 2022/4/12 16:30
 */
@Data
public class ArOrderDtlDTO implements Serializable {

    private static final long serialVersionUID = 1143572367019060308L;
    private Long id;

    private Long masId;

    private String sourceNo;

    private Integer sourceLine;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal exclTaxPrice;

    private BigDecimal price;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String buCode;

    private Long buId;

    private String buName;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("发货单号")
    private String es11;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    private Long es12;

    @ApiModelProperty("订单客户")
    private String es13;

    @ApiModelProperty("客户编码(子客户)")
    private String es14;

    @ApiModelProperty("未税单价")
    private BigDecimal es15;

    @ApiModelProperty("税码")
    private String es16;

    @ApiModelProperty("发票号")
    private String es17;

    @ApiModelProperty("发票类型")
    private String es18;

    @ApiModelProperty("收款协议")
    private String es19;

    @ApiModelProperty("业务员编码")
    private String es20;

    @ApiModelProperty("币种")
    private String es21;

    @ApiModelProperty("汇率")
    private BigDecimal es22;

    @ApiModelProperty("起算日期")
    private LocalDateTime es23;

    @ApiModelProperty("到期付款日")
    private LocalDateTime es24;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;
    @ApiModelProperty("已核销金额")
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    @ApiModelProperty("收款协议名称")
    private String protocolName;

    @ApiModelProperty("库存流水ID")
    private Long invIoId;

    @ApiModelProperty("大类编码")
    private String firstCateCode;
    @ApiModelProperty("大类名称")
    private String firstCateName;

    @ApiModelProperty("财务评估类公司类型")
    private String finAssessmentOuType;
    private String finAssessmentOuTypeName;

    @ApiModelProperty(value = "财务评估类值")
    @SysCode(sys = "yst-supp", mod = "FIN_ASSESSMENT")
    private String finAssessmentValue;
    @ApiModelProperty("财务评估类值")
    private String finAssessmentValueName;
}
