package com.elitesland.fin.provider.pay;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.pay.DrawBackResultDTO;
import com.elitesland.fin.dto.pay.DrawBackRpcDTO;
import com.elitesland.fin.dto.pay.PayRpcDTO;
import com.elitesland.fin.dto.pay.PayRpcResultDTO;
import com.elitesland.fin.service.pay.PayRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * @author zhiyu.he
 * @date 2022/12/28 10:36
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayRpcService.PATH)
public class PayRpcServiceImpl implements PayRpcService {
    @Override
    public PayRpcResultDTO pay(PayRpcDTO payRpcDTO) {
        if(CharSequenceUtil.isBlank(payRpcDTO.getOrderNumber())){
            throw new BusinessException("订单编号不能为空!");
        }
        if(CharSequenceUtil.isBlank(payRpcDTO.getPayMethod())){
            throw new BusinessException("支付方式不能为空!");
        }
        if(payRpcDTO.getPayAmount()==null){
            throw new BusinessException("支付金额不能为空!");
        }
        PayRpcResultDTO payRpcResultDTO = new PayRpcResultDTO();
        //付款金额
        payRpcResultDTO.setPayAmount(payRpcDTO.getPayAmount());
        //订单编号
        payRpcResultDTO.setOrderNumber(payRpcDTO.getOrderNumber());
        //支付方式
        payRpcResultDTO.setPayMethod(payRpcDTO.getPayMethod());
        //支付成功状态
        payRpcResultDTO.setStatus(true);
        //支付日期
        payRpcResultDTO.setReceiptDate(LocalDateTime.now());
        //收款类型
        payRpcResultDTO.setReceiptType(payRpcDTO.getReceiptType());
        //支付成功流水号
        UUID uuid = UUID.randomUUID();
        payRpcResultDTO.setReceiptSerial(uuid.toString());
        return payRpcResultDTO;
    }

    @Override
    public DrawBackResultDTO drawBack(DrawBackRpcDTO payRpcDTO) {
        if(CharSequenceUtil.isBlank(payRpcDTO.getOrderNumber())){
            throw new BusinessException("订单编号不能为空!");
        }
        if(CharSequenceUtil.isBlank(payRpcDTO.getPayMethod())){
            throw new BusinessException("支付方式不能为空!");
        }
        if(payRpcDTO.getPayAmount()==null){
            throw new BusinessException("退款金额不能为空!");
        }
        DrawBackResultDTO payRpcResultDTO = new DrawBackResultDTO();
        //付款金额
        payRpcResultDTO.setPayAmount(payRpcDTO.getPayAmount());
        //订单编号
        payRpcResultDTO.setOrderNumber(payRpcDTO.getOrderNumber());
        //支付方式
        payRpcResultDTO.setPayMethod(payRpcDTO.getPayMethod());
        //支付成功状态
        payRpcResultDTO.setStatus(true);
        //支付日期
        payRpcResultDTO.setReceiptDate(LocalDateTime.now());
        //收款类型
        payRpcResultDTO.setReceiptType(payRpcDTO.getReceiptType());
        //支付成功流水号
        UUID uuid = UUID.randomUUID();
        payRpcResultDTO.setReceiptSerial(uuid.toString());
        //付款方信息
        payRpcResultDTO.setPayOuId(payRpcDTO.getPayOuId());
        payRpcResultDTO.setPayOuCode(payRpcDTO.getPayOuCode());
        payRpcResultDTO.setPayOuName(payRpcDTO.getPayOuName());
        payRpcResultDTO.setPayAccount(payRpcDTO.getPayAccount());
        //收款方信息
        payRpcResultDTO.setReceiptOuId(payRpcDTO.getReceiptOuId());
        payRpcResultDTO.setReceiptOuCode(payRpcDTO.getReceiptOuCode());
        payRpcResultDTO.setReceiptOuName(payRpcDTO.getReceiptOuName());
        payRpcResultDTO.setReceiptAccount(payRpcDTO.getReceiptAccount());


        return payRpcResultDTO;
    }
}
