package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookOuParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSetOfBookOuVO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSetOfBookOuDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinSetOfBookOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QFinSetOfBookOuDO qFinSetOfBookOuDO = QFinSetOfBookOuDO.finSetOfBookOuDO;
    private final QFinSetOfBookDO qFinSetOfBookDO = QFinSetOfBookDO.finSetOfBookDO;

    public PagingVO<FinSetOfBookOuVO> page(FinSetOfBookOuParam finSetOfBookOuParam) {

        JPAQuery<FinSetOfBookOuVO> query = select(FinSetOfBookOuVO.class)
                .where(ExpressionUtils.allOf(where(finSetOfBookOuParam), whereSetOfBook(finSetOfBookOuParam)));

        finSetOfBookOuParam.setPaging(query);
        finSetOfBookOuParam.fillOrders(query, qFinSetOfBookOuDO);
        return PagingVO.<FinSetOfBookOuVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private Predicate where(FinSetOfBookOuParam finSetOfBookOuParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSetOfBookOuParam.getId() != null, qFinSetOfBookOuDO.id, finSetOfBookOuParam.getId())
                .andEq(Objects.nonNull(finSetOfBookOuParam.getOuId()), qFinSetOfBookOuDO.ouId, finSetOfBookOuParam.getOuId())
                .andEq(StrUtil.isNotBlank(finSetOfBookOuParam.getOuCode()), qFinSetOfBookOuDO.ouCode, finSetOfBookOuParam.getOuCode())
                .andLike(StrUtil.isNotBlank(finSetOfBookOuParam.getOuName()), qFinSetOfBookOuDO.ouName, finSetOfBookOuParam.getOuName())
                .andLike(StrUtil.isNotBlank(finSetOfBookOuParam.getKeyword()), new StringExpression[]{qFinSetOfBookOuDO.ouName, qFinSetOfBookOuDO.ouCode}, finSetOfBookOuParam.getKeyword())
                .build();
    }

    private Predicate whereSetOfBook(FinSetOfBookOuParam finSetOfBookOuParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(StrUtil.isNotBlank(finSetOfBookOuParam.getSobCode()), qFinSetOfBookDO.sobCode, finSetOfBookOuParam.getSobCode())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {

        return jpaQueryFactory.select(Projections.bean(cls,
                qFinSetOfBookOuDO.id,
                qFinSetOfBookOuDO.ouId,
                qFinSetOfBookOuDO.ouCode,
                qFinSetOfBookOuDO.ouName,
                qFinSetOfBookOuDO.createTime,
                qFinSetOfBookOuDO.creator,
                qFinSetOfBookOuDO.modifyTime,
                qFinSetOfBookOuDO.updater,
                qFinSetOfBookOuDO.masId,

                qFinSetOfBookDO.sobCode,
                qFinSetOfBookDO.sobName,
                qFinSetOfBookDO.accountPeriodCode,
                qFinSetOfBookDO.accountPeriodName,
                qFinSetOfBookDO.currCode,
                qFinSetOfBookDO.currName,
                qFinSetOfBookDO.status

        )).from(qFinSetOfBookOuDO).innerJoin(qFinSetOfBookDO).on(qFinSetOfBookDO.id.eq(qFinSetOfBookOuDO.masId));
    }

}
