package com.elitesland.fin.rpc.pur;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @description: 采购域
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/3/8 2:59 下午
 * @version:v1.0
 */
public interface RmiPurRpcService {

    /**
     * 更新对账单状态
     *
     * @param purAccountDTO
     */
    void batchUpdateDocStatus(PurAccountDTO purAccountDTO);

    /**
     * 回写采购对账单开票数量
     *
     * @param purAccountCheckQtyDTOList 采购对账单开票数量
     */
    void addInvoiceQty(List<PurAccountCheckQtyDTO> purAccountCheckQtyDTOList);

    /**
     * 获取供应商信息
     */
    List<PurSuppBaseDTO> findBySuppIdBatch(@RequestBody List<Long> ids);

    List<PurAccountCheckDtlRpcDTO> findPurAccountCheckDtlByParam(List<String> suppCodes);

    Map<String,PurAccountCheckDtlRpcDTO> findPurAccountCheckDtlMapByCodes(List<String> suppCodes);
}
