/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.payorder;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderDtlConvert;
import com.elitesland.fin.application.convert.payorder.SyncRecordConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.SyncRecordParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.domain.service.payorder.SyncRecordDomainService;
import com.elitesland.fin.dto.payorder.OrderAmtRpcDTO;
import com.elitesland.fin.dto.payorder.PayOrderDtlRpcDTO;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.dto.payorder.SyncRecordRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.payorder.SyncRecordDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.param.payorder.OrderAmtRpcParam;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import com.elitesland.fin.param.payorder.PayOrderSyncRpcParam;
import com.elitesland.fin.service.payorder.PayOrderRpcService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/payOrder"})
public class PayOrderRpcServiceImpl
implements PayOrderRpcService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderRpcServiceImpl.class);
    public final PayOrderDomainService payOrderDomainService;
    private final PayOrderDtlDomainService payOrderDtlDomainService;
    private final SyncRecordDomainService syncRecordDomainService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    public Long save(PayOrderRpcParam payOrderRpcParam) {
        if (CharSequenceUtil.isBlank((CharSequence)payOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertRpc(payOrderRpcParam);
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = this.payOrderDomainService.save(payOrder);
        return resId;
    }

    public PayOrderRpcDTO save2(PayOrderRpcParam payOrderRpcParam) {
        if (CharSequenceUtil.isBlank((CharSequence)payOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertRpc(payOrderRpcParam);
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = this.payOrderDomainService.save(payOrder);
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(resId, false);
        PayOrderRpcDTO payOrderRpcDTO = PayOrderConvert.INSTANCE.convertDtoToRpc(payOrderDTO);
        return payOrderRpcDTO;
    }

    public ApiResult<PagingVO<PayOrderRpcDTO>> page(PayOrderPageRpcParam payOrderPageRpcParam) {
        PayOrderPageParam payOrderPageParam = PayOrderConvert.INSTANCE.convertPageParamRpc(payOrderPageRpcParam);
        PagingVO<PayOrderRpcDTO> res = PayOrderConvert.INSTANCE.convertRpcDto(this.payOrderDomainService.page(payOrderPageParam));
        return ApiResult.ok(res);
    }

    public ApiResult<List<PayOrderRpcDTO>> payOrderDetails(@RequestBody PayOrderPageRpcParam payOrderPageRpcParam) {
        PayOrderPageParam payOrderPageParam = PayOrderConvert.INSTANCE.convertPageParamRpc(payOrderPageRpcParam);
        payOrderPageParam.setSize(100000);
        PagingVO<PayOrderDTO> page = this.payOrderDomainService.page(payOrderPageParam);
        if (page.getTotal() <= 0L) {
            return ApiResult.ok(new ArrayList());
        }
        PagingVO<PayOrderRpcDTO> res = PayOrderConvert.INSTANCE.convertRpcDto(page);
        List records = res.getRecords();
        List<Long> idList = records.stream().map(PayOrderRpcDTO::getId).toList();
        Map<Long, List<PayOrderDtlDTO>> collect = this.payOrderDtlDomainService.queryByMasId(idList).stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId));
        SyncRecordParam recordParam = new SyncRecordParam();
        recordParam.setPayOrderIdList(idList);
        Map<Long, List<SyncRecordDTO>> recordMap = this.syncRecordDomainService.findSyncRecord(recordParam).stream().collect(Collectors.groupingBy(SyncRecordDTO::getPayOrderId));
        for (PayOrderRpcDTO order : records) {
            List<SyncRecordDTO> recordDTOList;
            List<PayOrderDtlDTO> payOrderDtlDTOS = collect.get(order.getId());
            if (CollectionUtils.isNotEmpty(payOrderDtlDTOS)) {
                List<PayOrderDtlRpcDTO> dtlRpcDTOList = PayOrderDtlConvert.INSTANCE.convertRpcDto(payOrderDtlDTOS);
                order.setPayOrderDtlVOList(dtlRpcDTOList);
            }
            if (!CollectionUtils.isNotEmpty(recordDTOList = recordMap.get(order.getId()))) continue;
            List<SyncRecordRpcDTO> dtlRpcDTOList = SyncRecordConvert.INSTANCE.convertRpcDto(recordDTOList);
            order.setRecordList(dtlRpcDTOList);
        }
        return ApiResult.ok((Object)records);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> updateSyncStatus(PayOrderSyncRpcParam param) {
        log.info("\u53f8\u5e93\u540c\u6b65\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString((Object)param));
        List<PayOrderDO> payOrderDOS = this.payOrderDomainService.queryByIds(Collections.singletonList(param.getId()));
        if (CollectionUtils.isEmpty(payOrderDOS)) {
            return ApiResult.fail((String)"\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        PayOrderDTO payOrderDTO = new PayOrderDTO();
        payOrderDTO.setId(param.getId());
        payOrderDTO.setSyncStatus(param.getSyncStatus());
        payOrderDTO.setSyncError(param.getSyncError());
        payOrderDTO.setOutSysKey(param.getOutSysKey());
        this.payOrderRepoProc.updateSyncStatus(payOrderDTO);
        if (UdcEnum.PAY_ORDER_SYNC_STATUS_SYNC_SUCCESS.getValueCode().equals(param.getSyncStatus()) || UdcEnum.PAY_ORDER_SYNC_STATUS_SYNC_FAIL.getValueCode().equals(param.getSyncStatus())) {
            if (param.getSyncRecord() == null) {
                return ApiResult.fail((String)"\u540c\u6b65\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            SyncRecordRpcDTO syncRecord = param.getSyncRecord();
            this.syncRecordDomainService.save(SyncRecordConvert.INSTANCE.convert(syncRecord));
        }
        return ApiResult.ok();
    }

    public ApiResult<OrderAmtRpcDTO> queryOrderAmtByOuIdAndSuppId(OrderAmtRpcParam param) {
        OrderAmtRpcDTO amtDTO = new OrderAmtRpcDTO();
        param.setFilterDocStatusList(Collections.singletonList("VOID"));
        List<PayOrderDTO> payOrderDTOS = this.payOrderRepoProc.queryOrderAmt(param);
        if (CollectionUtils.isEmpty(payOrderDTOS)) {
            amtDTO.setPayOrderAmt(BigDecimal.ZERO);
        } else {
            BigDecimal reduce = payOrderDTOS.stream().map(PayOrderDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            amtDTO.setPayOrderAmt(reduce);
        }
        param.setFilterDocStatusList(Collections.singletonList("VOID"));
        List<ApOrderDTO> apOrderDTOS = this.apOrderRepoProc.queryOrderAmt(param);
        if (CollectionUtils.isEmpty(apOrderDTOS)) {
            amtDTO.setApOrderAmt(BigDecimal.ZERO);
        } else {
            BigDecimal reduce = apOrderDTOS.stream().map(ApOrderDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            amtDTO.setApOrderAmt(reduce);
        }
        return ApiResult.ok((Object)amtDTO);
    }

    public PayOrderRpcServiceImpl(PayOrderDomainService payOrderDomainService, PayOrderDtlDomainService payOrderDtlDomainService, SyncRecordDomainService syncRecordDomainService, PayOrderRepoProc payOrderRepoProc, ApOrderRepoProc apOrderRepoProc) {
        this.payOrderDomainService = payOrderDomainService;
        this.payOrderDtlDomainService = payOrderDtlDomainService;
        this.syncRecordDomainService = syncRecordDomainService;
        this.payOrderRepoProc = payOrderRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
    }
}

