package com.elitesland.fin.application.facade.param.expense;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Auther: Mark
 * @Date: 2024/8/30 09:41
 * @Description:
 */
@Data
public class ExpLedgerSaveParam implements Serializable {
    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) DEFAULT NULL COMMENT '公司ID'")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '公司编码'")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '公司名称'")
    private String ouName;

    @ApiModelProperty("物流公司")
    @Column(name = "carrier", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '物流公司'")
    private String carrier;

    @ApiModelProperty("物流公司名称")
    @Column(name = "carrier_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '物流公司名称'")
    private String carrierName;

    @ApiModelProperty("物流公司类型")
    @Column(name = "carrier_type", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '物流公司类型'")
    private String carrierType;

    @ApiModelProperty("品牌")
    @Column(name = "brand", columnDefinition = "varchar(32) DEFAULT NULL COMMENT '品牌'")
    private String brand;

    @ApiModelProperty("品牌名称")
    @Column(name = "brand_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '品牌名称'")
    private String brandName;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) DEFAULT NULL COMMENT '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '客户编码'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '客户名称'")
    private String custName;

    @ApiModelProperty("门店ID")
    @Column(name = "store_id", columnDefinition = "bigint(20) DEFAULT NULL COMMENT '门店ID'")
    private Long storeId;

    @ApiModelProperty("门店编码")
    @Column(name = "store_code", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '门店编码'")
    private String storeCode;

    @ApiModelProperty("门店名称")
    @Column(name = "store_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '门店名称'")
    private String storeName;

    @ApiModelProperty("费用类型代码")
    @Column(name = "exp_type_code", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '费用类型代码'")
    private String expTypeCode;

    @ApiModelProperty("费用类型名称")
    @Column(name = "exp_type_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '费用类型名称'")
    private String expTypeName;

    @ApiModelProperty("单据类型")
    @Column(name = "doc_type", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '单据类型'")
    private String docType;

    @ApiModelProperty("单据类型名称")
    @Column(name = "doc_type_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '单据类型名称'")
    private String docTypeName;

    @ApiModelProperty("来源单号")
    @Column(name = "source_doc_no", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '来源单号'")
    private String sourceDocNo;

    @ApiModelProperty("来源单据日期")
    @Column(name = "source_doc_no_date", columnDefinition = "date DEFAULT NULL COMMENT '来源单据日期'")
    private LocalDate sourceDocNoDate;

    @ApiModelProperty("含税金额")
    @Column(name = "amt", columnDefinition = "DECIMAL(20,8) DEFAULT NULL COMMENT '含税金额'")
    private BigDecimal amt;

    @ApiModelProperty("未税金额")
    @Column(name = "net_amt", columnDefinition = "DECIMAL(20,8) DEFAULT NULL COMMENT '未税金额'")
    private BigDecimal netAmt;

    @ApiModelProperty("税额")
    @Column(name = "taxAmt", columnDefinition = "DECIMAL(20,8) DEFAULT NULL COMMENT '税额'")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,8) DEFAULT NULL COMMENT '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("规则名称")
    @Column(name = "rule_name", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '规则名称'")
    private String ruleName;

    @ApiModelProperty("单据状态")
    @Column(name = "order_state", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '单据状态'")
    private String orderState;

    @ApiModelProperty("计算状态")
    @Column(name = "cal_state", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '计算状态'")
    private String calState;

    @ApiModelProperty("计算失败原因")
    @Column(name = "cal_error", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '计算失败原因'")
    private String calError;

    @ApiModelProperty("生成财务单据标识 0-未生成；1-已生成；2-生成失败")
    @Column(name = "fin_flag", columnDefinition = "varchar(32) DEFAULT NULL COMMENT '生成财务单据标识 0-未生成；1-已生成；2-生成失败'")
    private String finFlag;

    @ApiModelProperty("生成失败原因")
    @Column(name = "fin_error", columnDefinition = "varchar(255) DEFAULT NULL COMMENT '生成失败原因'")
    private String finError;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("单据金额")
    private BigDecimal docAmt;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("出入库单据号")
    private String stockNo;

    @ApiModelProperty("出入库日期")
    private LocalDateTime stockDate;
}
