package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.invoice.InvoiceRuleConfigConvert;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRuleConfigVO;
import com.elitesland.fin.application.service.invoice.InvoiceRuleConfigService;
import com.elitesland.fin.entity.invoice.InvoiceRuleConfigDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepo;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/11
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceRuleConfigServiceImpl implements InvoiceRuleConfigService {

    private final InvoiceRuleConfigRepo invoiceRuleConfigRepo;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;

    @SysCodeProc
    @Override
    public PagingVO<InvoiceRuleConfigVO> page(InvoiceRuleConfigQueryParam param) {
        PagingVO<InvoiceRuleConfigDTO> pagingDTO = invoiceRuleConfigRepoProc.queryPaging(param);
        return InvoiceRuleConfigConvert.INSTANCE.dto2PagingVO(pagingDTO);
    }

    @SysCodeProc
    @Override
    public InvoiceRuleConfigVO detail(Long masId) {
        Optional<InvoiceRuleConfigDO> byId = invoiceRuleConfigRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new BusinessException("未查询到当前发票设置信息");
        }
        InvoiceRuleConfigVO detailVO = InvoiceRuleConfigConvert.INSTANCE.do2DetailVO(byId.get());
        return detailVO;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long saveOrUpdate(InvoiceRuleConfigSaveParam param) {
        this.validateSaveOrUpdateParam(param);
        // 新增
        if(ObjectUtil.isNull(param.getId())){
            if (invoiceRuleConfigRepo.existsByOptDocClsAndOptDocTypeAndOptDocStatus(param.getOptDocCls(), param.getOptDocType(), param.getOptDocStatus())) {
                throw new BusinessException("已存在相同的发票设置");
            }
        }
        InvoiceRuleConfigDO invoiceRuleConfigDO = InvoiceRuleConfigConvert.INSTANCE.param2DO(param);
        InvoiceRuleConfigDO save = invoiceRuleConfigRepo.save(invoiceRuleConfigDO);
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delById(Long id) {
        if (ObjUtil.isNull(id)) {
            throw new BusinessException("需要删除的发票设置不能为空");
        }
        invoiceRuleConfigRepo.deleteById(id);
    }

    private void validateSaveOrUpdateParam(InvoiceRuleConfigSaveParam param) {
//        Assert.notBlank(param.getOuName(), "公司名称必填");
//        Assert.notBlank(param.getOuCode(), "公司信息必填");
        Assert.notBlank(param.getOptDocCls(), "适用单据必填");
        //Assert.notBlank(param.getStatus(), "启用状态必填");
        Assert.notBlank(param.getOptDocType(), "单据类型必填");
        Assert.notBlank(param.getOptDocStatus(), "单据状态必填");
        Assert.notNull(param.getInvoiceLimit(), "可开票时限必填");
        Assert.notNull(param.getAutoReview(), "是否自动审核必填");
        Assert.notNull(param.getAutoInvoice(), "是否自动开票必填");
        Assert.notNull(param.getNeedRedraft(), "发票红冲前是否需要换开申请审核必填");
    }

}
