package com.elitesland.fin.application.web.flow;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/accountFlow")
@RequiredArgsConstructor
@Api(value = "账户流水", tags = {"账户流水"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW, businessDoClass = AccountFlowDO.class)
public class AccountFlowController {
    private final AccountFlowService accountFlowService;
    private final AccountFlowRpcService accountFlowRpcService;

    @PostMapping("/page")
    @ApiOperation("账户流水分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "账户流水分页",
            businessObjectType = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW,operationCode = FinBusinessObjectConstant.FIN_ACCOUNT_FLOW_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<AccountFlowVO>> page(@RequestBody AccountFlowPageParam pageParam) {
        var ret = accountFlowService.page(pageParam);
        return ApiResult.ok(ret);
    }

//    @PostMapping("/save")
//    @ApiOperation("账户流水保存")
//    public ApiResult<AccountFlowVO> save(@RequestBody List<AccountFlowParam> paramList) {
//        var ret = accountFlowService.save(paramList);
//        return ApiResult.ok(ret);
//    }

    @PostMapping("/save")
    @ApiOperation("账户流水保存")
    public ApiResult<Void> save(@RequestBody AccountFlowParam param) {
        accountFlowService.saveAccountFlow(param);
        return ApiResult.ok();
    }

    @PostMapping("/approve")
    @ApiOperation("审批通过")
    public ApiResult<List<Void>> approve(@RequestBody AccountFlowParam accountFlowParam) {
        accountFlowService.approve(accountFlowParam);
        return ApiResult.ok();
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝")
    public ApiResult<List<Void>> reject(@RequestBody AccountFlowParam accountFlowParam) {
        accountFlowService.reject(accountFlowParam);
        return ApiResult.ok();
    }

    @DeleteMapping("del")
    @ApiOperation("删除账户流水")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        accountFlowService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }


}
