package com.elitesland.fin.domain.service.inputinv;

import com.elitesland.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 13:07
 */
public interface InputInvDomainService {

    /**
     * 分页查询进项发票
     *
     * @param param 查询条件
     * @return
     */
    PagingVO<InputInvDTO> page(InputInvPageParam param);

    /**
     * 根据主键删除数据
     * @param ids
     * @return
     */
    List<Long> deleteByIds(List<Long> ids);

    /**
     * 根据主键查询数据
     *
     * @param id
     * @param flag 是否查询明细
     * @return
     */
    InputInvDTO queryById(Long id, Boolean flag);

    /**
     * 根据主键查询数据
     *
     * @param sourceNo
     * @return
     */
    List<InputInvDTO> queryBySourceNo(String sourceNo);

    /**
     * 保存发票数据
     *
     * @param inputInv 实体发票
     * @return 更新ID
     */
    Long save(InputInv inputInv);

    /**
     * 提交发票数据
     *
     * @param inputInv 实体付款单
     * @return 更新ID
     */
    Long submit(InputInv inputInv);

    /**
     * 审批通过
     * @param id 主键ID
     */
    void approved(Long id, SysUserDTO user);

    /**
     * 审批拒绝
     * @param param
     */
    void reject(InputInvParam param, SysUserDTO user);


    void updateWorkInfo(ProcessInfo processInfo, Long resId);

    /**
     *批量保存进行发票
     *
     * @param inputInvs 实体发票
     * @return
     */
    void saveAll(List<InputInv> inputInvs);

    /**
     * 保存应付单号
     * @param createMode
     * @param sourceNo
     * @param apOrderNo
     */
    void savaApOrderNo(String createMode,String sourceNo, String apOrderNo);

    /**
     * 删除应付单号
     * @param createMode
     * @param sourceNo
     */
    public void removeApOrderNo(String createMode,String sourceNo);

    /**
     * 根据参数查询所有的进行发票
     * @param param
     * @return
     */
    List<InputInvDTO> findAllByParam(InputInvPageParam param);
}
