package com.elitesland.fin.repo.accountingengine;

import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.QFinAccountEngineDetailsDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinAccountEngineDetailsRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinAccountEngineDetailsDO qFinAccountEngineDetailsDO = QFinAccountEngineDetailsDO.finAccountEngineDetailsDO;

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinAccountEngineDetailsDO.id,
                qFinAccountEngineDetailsDO.masId,
                qFinAccountEngineDetailsDO.serialNum,
                qFinAccountEngineDetailsDO.accountEngine,
                qFinAccountEngineDetailsDO.activeFlag,

                qFinAccountEngineDetailsDO.createTime,
                qFinAccountEngineDetailsDO.creator,
                qFinAccountEngineDetailsDO.modifyTime,
                qFinAccountEngineDetailsDO.updater,
                qFinAccountEngineDetailsDO.proposedType
        )).from(qFinAccountEngineDetailsDO);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateProposedType(Long id) {
        JPAUpdateClause update = jpaQueryFactory.update(qFinAccountEngineDetailsDO);
        update.set(qFinAccountEngineDetailsDO.proposedType, UdcEnum.PROPOSED_TYPE_MANUAL.getValueCode());
        update.set(qFinAccountEngineDetailsDO.transferType, UdcEnum.PROPOSED_TYPE_MANUAL.getValueCode());
        update.set(qFinAccountEngineDetailsDO.modifyTime, LocalDateTime.now());
        update.where(qFinAccountEngineDetailsDO.id.eq(id)).execute();
    }
}
