/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractDetailConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAbstractDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAbstractParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractVO;
import com.elitesland.fin.application.service.accountingengine.FinAbstractService;
import com.elitesland.fin.domain.entity.accountingengine.FinAbstractDO;
import com.elitesland.fin.repo.accountingengine.FinAbstractDetailRepo;
import com.elitesland.fin.repo.accountingengine.FinAbstractRepo;
import com.elitesland.fin.repo.accountingengine.FinAbstractRepoProc;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAbstractServiceImpl
implements FinAbstractService {
    private static final Logger log = LoggerFactory.getLogger(FinAbstractServiceImpl.class);
    private final FinAbstractRepo finAbstractRepo;
    private final FinAbstractRepoProc finAbstractRepoProc;
    private final FinAbstractDetailRepo finAbstractDetailRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinAbstractParam param) {
        param.setDetailList(Optional.ofNullable(param.getDetailList()).orElse(Collections.emptyList()));
        Assert.notEmpty((CharSequence)param.getCode(), (String)"\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getName(), (String)"\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getEventId(), (String)"\u4e8b\u4ef6\u8868\u5355\u5fc5\u586b", (Object[])new Object[0]);
        FinAbstractDO finAbstractDO = this.finAbstractRepo.findByCode(param.getCode());
        if (!(finAbstractDO == null || param.getId() != null && param.getId().equals(finAbstractDO.getId()))) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        FinAbstractDO abstractDO = FinAbstractConvert.INSTANCE.paramToDO(param);
        FinAbstractDO save = (FinAbstractDO)this.finAbstractRepo.save(abstractDO);
        this.finAbstractDetailRepo.deleteAllByMasId(save.getId());
        if (CollectionUtils.isNotEmpty(param.getDetailList())) {
            AtomicReference<Integer> lineNo = new AtomicReference<Integer>(1);
            param.getDetailList().forEach(item -> {
                item.setMasId(save.getId());
                item.setLineNo(lineNo.getAndSet((Integer)lineNo.get() + 1));
            });
            this.finAbstractDetailRepo.saveAll(FinAbstractDetailConvert.INSTANCE.paramToDO(param.getDetailList()));
        }
        return save.getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<FinAbstractVO> page(FinAbstractParam param) {
        PagingVO<FinAbstractDTO> page = this.finAbstractRepoProc.page(param);
        return FinAbstractConvert.INSTANCE.dtoToVo(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(FinAbstractParam param) {
        Assert.notEmpty(param.getIdList(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.finAbstractRepo.deleteByIdIn(param.getIdList());
        this.finAbstractDetailRepo.deleteAllByMasIdIn(param.getIdList());
    }

    @Override
    public void updateStatus(FinAbstractParam param) {
        this.finAbstractRepoProc.updateStatus(param);
    }

    public FinAbstractServiceImpl(FinAbstractRepo finAbstractRepo, FinAbstractRepoProc finAbstractRepoProc, FinAbstractDetailRepo finAbstractDetailRepo) {
        this.finAbstractRepo = finAbstractRepo;
        this.finAbstractRepoProc = finAbstractRepoProc;
        this.finAbstractDetailRepo = finAbstractDetailRepo;
    }
}

