/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.creditAccountFlow;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.creditAccountFlow.CreditAccountFlowDomainService;
import com.elitesland.fin.domain.service.creditaccount.CreditAccountDomainService;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditAccountFlowDomainServiceImpl
implements CreditAccountFlowDomainService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountFlowDomainServiceImpl.class);
    private final CreditAccountFlowRepo creditAccountFlowRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final CreditAccountDomainService creditAccountDomainService;
    private final CreditAccountFlowRepoProc creditAccountFlowRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CreditAccountFlowDO save(CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(creditAccountFlowParam);
        this.flexFieldUtilService.handFlexFieldValueFeference("CREDIT_ACCOUNT_FLOW", (Object)creditAccountFlowDO);
        creditAccountFlowDO = (CreditAccountFlowDO)((Object)this.creditAccountFlowRepo.save((Object)creditAccountFlowDO));
        return creditAccountFlowDO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBalanceAndGenerateCreditAccountFlow(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.forEach(v -> {
            CreditAccountDTO newCreditAccountDTO;
            CreditAccountFlowParam creditAccountFlowParam = v;
            CreditAccountDTO oldCreditAccountDTO = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals((Object)oldCreditAccountDTO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountDomainService.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newCreditAccountDTO = this.creditAccountRepoProc.get(oldCreditAccountDTO.getId())) == null) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit = newCreditAccountDTO.getCreditAccountAvailableLimit();
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            SysUserDTO user = this.getUser();
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            CreditAccountFlowDO creditAccountFlowDO = this.save(creditAccountFlowParam);
            creditAccountFlowParam.setId(creditAccountFlowDO.getId());
        });
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCreditAccountFlowList(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.stream().forEach(v -> {
            CreditAccountFlowDO creditAccountFlowDO = this.save((CreditAccountFlowParam)((Object)v));
            v.setId(creditAccountFlowDO.getId());
        });
    }

    @Override
    public List<CreditAccountFlowVO> findBySourceIds(List<Long> ids) {
        return this.creditAccountFlowRepoProc.findBySourceIds(ids);
    }

    public CreditAccountFlowDomainServiceImpl(CreditAccountFlowRepo creditAccountFlowRepo, FlexFieldUtilService flexFieldUtilService, CreditAccountRepoProc creditAccountRepoProc, CreditAccountDomainService creditAccountDomainService, CreditAccountFlowRepoProc creditAccountFlowRepoProc) {
        this.creditAccountFlowRepo = creditAccountFlowRepo;
        this.flexFieldUtilService = flexFieldUtilService;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.creditAccountDomainService = creditAccountDomainService;
        this.creditAccountFlowRepoProc = creditAccountFlowRepoProc;
    }
}

