/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.fin.infinity.vo.SshVo;
import java.io.IOException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionManager.class);
    private static SSHClient ssh;
    private static SshVo sshVo;
    private static Timer keepAliveTimer;
    private static int keepAliveInterval;

    public static synchronized void init() throws IOException {
        if (ssh == null || !ssh.isConnected()) {
            String ip = SpringUtil.getProperty((String)"TC.StatementAccount.ip");
            String port = SpringUtil.getProperty((String)"TC.StatementAccount.port");
            String user = SpringUtil.getProperty((String)"TC.StatementAccount.user");
            String password = SpringUtil.getProperty((String)"TC.StatementAccount.password");
            log.info("\u5c1d\u8bd5\u8fde\u63a5 SSH \u670d\u52a1\u5668: {}", (Object)Thread.currentThread().getName());
            SSHClient sshClient = new SSHClient();
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            sshClient.connect(ip, Integer.valueOf(port).intValue());
            sshClient.authPassword(user, password);
            ssh = sshClient;
            SshConnectionManager.startKeepAlive(keepAliveInterval);
            log.info("\u8fde\u63a5 SSH \u670d\u52a1\u5668\u5b8c\u6210: {}", (Object)Thread.currentThread().getName());
        }
    }

    public static void startKeepAlive(int intervalSeconds) {
        keepAliveInterval = intervalSeconds;
        if (keepAliveTimer != null) {
            keepAliveTimer.cancel();
        }
        keepAliveTimer = new Timer(true);
        keepAliveTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    SshConnectionManager.validateConnection();
                }
                catch (Exception e) {
                    log.warn("SSH \u4fdd\u6d3b\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u8fde: {}", (Object)e.getMessage());
                    try {
                        SshConnectionManager.reconnect();
                    }
                    catch (IOException ex) {
                        log.error("SSH \u91cd\u8fde\u5931\u8d25: {}", (Object)ex.getMessage());
                    }
                }
            }
        }, intervalSeconds * 1000, (long)(intervalSeconds * 1000));
    }

    public static boolean validateConnection() {
        boolean bl;
        block9: {
            if (ssh == null || !ssh.isConnected()) {
                return false;
            }
            Session session = ssh.startSession();
            try {
                Session.Command cmd = session.exec("exit 0");
                cmd.join(5L, TimeUnit.SECONDS);
                boolean bl2 = bl = cmd.getExitStatus() == 0;
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("SSH \u8fde\u63a5\u9a8c\u8bc1\u5931\u8d25: {}", (Object)e.getMessage());
                    return false;
                }
            }
            session.close();
        }
        return bl;
    }

    public static synchronized void reconnect() throws IOException {
        log.info("\u8fdb\u5165\u91cd\u8fde");
        if (SshConnectionManager.validateConnection()) {
            return;
        }
        if (ssh != null) {
            try {
                ssh.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("ssh\u65ad\u5f00\u91cd\u65b0\u8fde\u63a5\uff1a{}", (Object)Thread.currentThread().getName());
        }
        SshConnectionManager.init();
        sshVo = new SshVo(ssh, ssh.newSFTPClient());
        log.info("\u91cd\u8fde\u5b8c\u6210");
    }

    public static SshVo getSshVo() throws IOException {
        if (!SshConnectionManager.validateConnection()) {
            SshConnectionManager.reconnect();
            return sshVo;
        }
        while (Objects.isNull(sshVo)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.info("\u7b49\u5f85\u8fde\u63a5\u5bf9\u8c61\u521d\u59cb\u5316\u5b8c\u6210");
        }
        return sshVo;
    }

    public void close() {
        if (keepAliveTimer != null) {
            keepAliveTimer.cancel();
        }
        if (ssh != null) {
            try {
                ssh.disconnect();
            }
            catch (Exception e) {
                log.warn("\u5173\u95ed SSH \u8fde\u63a5\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
    }

    static {
        keepAliveInterval = 60;
    }
}

