/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.payorder;

import com.elitesland.fin.domain.entity.payorder.QPayOrderSyncRecordDO;
import com.elitesland.fin.domain.param.payorder.SyncRecordParam;
import com.elitesland.fin.infr.dto.payorder.SyncRecordDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SyncRecordRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderSyncRecordDO payOrderSyncRecordDO = QPayOrderSyncRecordDO.payOrderSyncRecordDO;

    public List<SyncRecordDTO> findSyncRecord(SyncRecordParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SyncRecordDTO.class, (Expression[])new Expression[]{this.payOrderSyncRecordDO.id, this.payOrderSyncRecordDO.payOrderId, this.payOrderSyncRecordDO.payOrderNo, this.payOrderSyncRecordDO.businessNo, this.payOrderSyncRecordDO.seqNo, this.payOrderSyncRecordDO.syncStatus, this.payOrderSyncRecordDO.syncError, this.payOrderSyncRecordDO.outSysKey})).from((EntityPath)this.payOrderSyncRecordDO);
        List<Predicate> predicates = this.pageWhere(param);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    private List<Predicate> pageWhere(SyncRecordParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotEmpty((CharSequence)param.getPayOrderNo())) {
            predicates.add((Predicate)this.payOrderSyncRecordDO.payOrderNo.eq((Object)param.getPayOrderNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getPayOrderNoList())) {
            predicates.add((Predicate)this.payOrderSyncRecordDO.payOrderNo.in(param.getPayOrderNoList()));
        }
        if (param.getPayOrderId() != null) {
            predicates.add((Predicate)this.payOrderSyncRecordDO.payOrderId.eq((Object)param.getPayOrderId()));
        }
        if (CollectionUtils.isNotEmpty(param.getPayOrderIdList())) {
            predicates.add((Predicate)this.payOrderSyncRecordDO.payOrderId.in(param.getPayOrderIdList()));
        }
        return predicates;
    }

    public SyncRecordRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

