/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.dto.accountingengine.FinFlexibleRpcDTO;
import com.elitesland.fin.param.accountingengine.FinFlexibleValueSaveRpcParam;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.service.accountingengine.FinFlexibleRpcService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/finFlexible"})
public class FinFlexibleRpcServiceImpl
implements FinFlexibleRpcService {
    private static final Logger log = LoggerFactory.getLogger(FinFlexibleRpcServiceImpl.class);
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;

    public ApiResult<FinFlexibleRpcDTO> findFlexibleByCode(String flexibleCode) {
        List<FinFlexibleDO> code = this.finFlexibleRepo.findAllByFlexibleCode(flexibleCode);
        if (CollectionUtils.isEmpty(code)) {
            return ApiResult.fail((String)(code + "\u503c\u96c6\u4e0d\u5b58\u5728"));
        }
        FinFlexibleDO finFlexibleDO = code.get(0);
        FinFlexibleRpcDTO rpcDTO = FinFlexibleConvert.INSTANCE.doToRpcDTO(finFlexibleDO);
        List<FinFlexibleValueDO> valueDOList = this.finFlexibleValueRepo.findAllByMasIdAndDeleteFlag(finFlexibleDO.getId(), 0);
        if (CollectionUtils.isNotEmpty(valueDOList)) {
            rpcDTO.setDetailList(FinFlexibleValueConvert.INSTANCE.doToRpcDTO(valueDOList));
        }
        return ApiResult.ok((Object)rpcDTO);
    }

    public ApiResult<Void> batchSave(List<FinFlexibleValueSaveRpcParam> paramList) {
        List list = paramList.stream().filter(t -> t.getMasId() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new RuntimeException("masId\u7f3a\u5931");
        }
        paramList.forEach(item -> {
            Assert.notNull((Object)item.getMasId(), (String)"masId\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getFlexibleValueCode(), (String)"\u503c\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getFlexibleValueName(), (String)"\u503c\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getDescendantsFlag(), (String)"\u662f\u5426\u6709\u5b50\u4ee3\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getActiveFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getAccountFlag(), (String)"\u662f\u5426\u8bb0\u8d26\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getActiveStartTime(), (String)"\u8d77\u59cb\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getActiveEndTime(), (String)"\u7ec8\u6b62\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
        });
        List<FinFlexibleValueDO> valueDOS = FinFlexibleValueConvert.INSTANCE.rpcParamToDO(paramList);
        this.finFlexibleValueRepo.saveAll(valueDOS);
        return ApiResult.ok();
    }

    public FinFlexibleRpcServiceImpl(FinFlexibleRepo finFlexibleRepo, FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleValueRepoProc finFlexibleValueRepoProc) {
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
    }
}

