/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.aporder;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.dto.aporder.ApArOrderHandleRpcDTO;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.param.aporder.ApArOrderHandleRpcParam;
import com.elitesland.fin.param.aporder.ApOrderPageRpcParam;
import com.elitesland.fin.param.aporder.ApOrderRpcParam;
import com.elitesland.fin.param.aporder.ApOrderSyncResultRpcParam;
import com.elitesland.fin.param.aporder.ApOrderSyncRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/apOrder"})
public class ApOrderRpcServiceImpl
implements ApOrderRpcService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderRpcServiceImpl.class);
    public final ApOrderDomainService apOrderDomainService;
    public final InputInvService inputInvService;
    public final ApArOrderService apArOrderService;

    public ApiResult<Long> save(ApOrderRpcParam apOrderRpcParam) {
        if (StringUtils.isBlank((CharSequence)apOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u5355\u636e\u6765\u6e90 createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convertRpc(apOrderRpcParam);
        Long resId = this.apOrderDomainService.save(apOrder);
        if (Boolean.TRUE.equals(apOrderRpcParam.getWriteInvFlag())) {
            ApOrderDTO apOrderDTO = this.apOrderDomainService.get(resId);
            this.inputInvService.savaApOrderNo(apOrderRpcParam.getCreateMode(), apOrderRpcParam.getSourceNo(), apOrderDTO.getApOrderNo());
        }
        return ApiResult.ok((Object)resId);
    }

    public ApiResult<ApOrderRpcDTO> queryApOrderById(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.getApOrderAndDtl(id);
        return ApiResult.ok((Object)ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO(apOrderDTO));
    }

    public ApiResult<PagingVO<ApOrderRpcDTO>> page(ApOrderPageRpcParam apOrderPageRpcParam) {
        ApOrderPageParam apOrderPageParam = ApOrderConvert.INSTANCE.convertPageParamRpc(apOrderPageRpcParam);
        PagingVO<ApOrderRpcDTO> res = ApOrderConvert.INSTANCE.convertRpcDto(this.apOrderDomainService.page(apOrderPageParam));
        return ApiResult.ok(res);
    }

    public ApiResult<ApArOrderHandleRpcDTO> invInterTranGenApAr(@RequestBody ApArOrderHandleRpcParam apArOrderRpcParam) {
        ApArOrderHandleRpcDTO apArOrderHandleRpcDTO = new ApArOrderHandleRpcDTO();
        ApOrder apOrder = ApOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getApOrderRpcParam());
        ArOrder arOrder = ArOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getArOrderRpcParam());
        ApArOrderHandleDTO apArOrderHandleDTO = this.apArOrderService.invInterTranCreateApArOrder(apOrder, arOrder);
        apArOrderHandleRpcDTO.setArResId(apArOrderHandleDTO.getArResId());
        apArOrderHandleRpcDTO.setArOrderNo(apArOrderHandleDTO.getArOrderNo());
        apArOrderHandleRpcDTO.setApResId(apArOrderHandleDTO.getApResId());
        apArOrderHandleRpcDTO.setApOrderNo(apArOrderHandleDTO.getApOrderNo());
        return ApiResult.ok((Object)apArOrderHandleRpcDTO);
    }

    public ApiResult<List<ApOrderRpcDTO>> findSyncApOrder(ApOrderSyncRpcParam param) {
        List<ApOrderDTO> syncApOrder = this.apOrderDomainService.findSyncApOrder(param);
        if (CollectionUtils.isEmpty(syncApOrder)) {
            return ApiResult.ok(new ArrayList());
        }
        List results = syncApOrder.stream().map(t -> {
            ApOrderRpcDTO apOrderRpcDTO = ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO((ApOrderDTO)t);
            if (CollectionUtils.isNotEmpty(t.getApOrderDtlDTOList())) {
                apOrderRpcDTO.setApOrderDtlRpcDTOList(t.getApOrderDtlDTOList().stream().map(ApOrderDtlConvert.INSTANCE::dtlToRpcDtl).collect(Collectors.toList()));
            } else {
                apOrderRpcDTO.setApOrderDtlRpcDTOList(new ArrayList());
            }
            return apOrderRpcDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(results);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> updateSyncStatus(List<ApOrderSyncResultRpcParam> param) {
        log.info("\u8d44\u4ea7\u5361\u7247\u540c\u6b65\u91d1\u8776\u72b6\u6001\u56de\u5199, \u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString(param));
        this.apOrderDomainService.updateSyncStatus(param);
        return ApiResult.ok();
    }

    public ApOrderRpcServiceImpl(ApOrderDomainService apOrderDomainService, InputInvService inputInvService, ApArOrderService apArOrderService) {
        this.apOrderDomainService = apOrderDomainService;
        this.inputInvService = inputInvService;
        this.apArOrderService = apArOrderService;
    }
}

