/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.inputinv;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.fin.dto.inputinv.InputInvRpcDTO;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.param.inputinv.InputInvRpcParam;
import com.elitesland.fin.service.inputinv.InputInvRpcService;
import com.esotericsoftware.minlog.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/inputInv"})
public class InputInvRpcServiceImpl
implements InputInvRpcService {
    public final InputInvDomainService inputInvDomainService;

    public Long save(InputInvRpcParam inputInvRpcParam) {
        if (CharSequenceUtil.isBlank((CharSequence)inputInvRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InputInv inputInv = InputInvConvert.INSTANCE.convertRpc(inputInvRpcParam);
        Long resId = this.inputInvDomainService.save(inputInv);
        return resId;
    }

    public ApiResult<InputInvRpcDTO> queryInputInvById(Long id) {
        InputInvDTO inputInvDTO = this.inputInvDomainService.queryById(id, true);
        return ApiResult.ok((Object)InputInvConvert.INSTANCE.inputInvDTO2InputInvRpcDTO(inputInvDTO));
    }

    @SysCodeProc
    public ApiResult<List<InputInvRpcDTO>> queryInputInvBySourceNo(String sourceNo) {
        List<InputInvDTO> inputInvDTO = this.inputInvDomainService.queryBySourceNo(sourceNo);
        if (CollectionUtils.isEmpty(inputInvDTO)) {
            return ApiResult.ok(new ArrayList());
        }
        ArrayList<InputInvRpcDTO> results = new ArrayList<InputInvRpcDTO>();
        for (InputInvDTO inputInvDTO1 : inputInvDTO) {
            results.add(InputInvConvert.INSTANCE.inputInvDTO2InputInvRpcDTO(inputInvDTO1));
        }
        return ApiResult.ok(results);
    }

    public ApiResult batchAdd(List<InputInvRpcParam> inputInvRpcParams) {
        Log.info((String)"\u6279\u91cf\u65b0\u589e\u53d1\u7968\uff1a{}", (String)JSON.toJSONString(inputInvRpcParams));
        if (CollectionUtils.isEmpty(inputInvRpcParams)) {
            throw new BusinessException("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (UdcEnum.FIN_PINV_CREATE_MODE_PACCK.getValueCode().equals(inputInvRpcParams.get(0).getCreateMode())) {
            InputInvPageParam inputInvPageParam = new InputInvPageParam();
            inputInvPageParam.setCreateMode(inputInvRpcParams.get(0).getCreateMode());
            inputInvPageParam.setSourceNo(inputInvRpcParams.get(0).getSourceNo());
            List<InputInvDTO> inputInvDTOS = this.inputInvDomainService.findAllByParam(inputInvPageParam);
            if (CollectionUtils.isNotEmpty(inputInvDTOS)) {
                Set set = inputInvDTOS.stream().map(v -> v.getSourceNo().concat(v.getInvNo())).collect(Collectors.toSet());
                inputInvRpcParams.forEach(v -> {
                    if (set.contains(v.getSourceNo().concat(v.getInvNo()))) {
                        throw new BusinessException("\u5bf9\u8d26\u5355\u53f7\u548c\u53d1\u7968\u53f7\u7801\u91cd\u590d");
                    }
                });
            }
        }
        List<InputInv> inputInvs = inputInvRpcParams.stream().map(v -> InputInvConvert.INSTANCE.convertRpc((InputInvRpcParam)v)).collect(Collectors.toList());
        this.inputInvDomainService.saveAll(inputInvs);
        return ApiResult.ok();
    }

    public InputInvRpcServiceImpl(InputInvDomainService inputInvDomainService) {
        this.inputInvDomainService = inputInvDomainService;
    }
}

