package com.elitesland.fin.domain.expense;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-11
 * @desc : 费用类型定义
 */
@Entity
@Table(name = "expense_type")
@org.hibernate.annotations.Table(appliesTo = "expense_type", comment = "费用类型定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ExpTypeDO extends BaseModel implements Serializable {

    @Column(name = "item_code", columnDefinition = "varchar(64) comment '商品代码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(128) comment '商品名称'")
    private String itemName;

    @Column(name = "exp_type_code", columnDefinition = "varchar(32) comment '费用类型代码'")
    private String expTypeCode;

    @Column(name = "exp_type_name", columnDefinition = "varchar(32) comment '费用类型名称'")
    private String expTypeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "source_doc", columnDefinition = "varchar(32) comment '来源单据'")
    private String sourceDoc;

    @Column(name = "source_doc_type", columnDefinition = "varchar(32) comment '来源单据类型'")
    private String sourceDocType;

    @Column(name = "source_doc_status", columnDefinition = "varchar(32) comment '来源单据状态'")
    private String sourceDocStatus;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpTypeDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpTypeDO entity = (ExpTypeDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
