package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractDetailConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAbstractDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAbstractParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractDetailVO;
import com.elitesland.fin.domain.entity.accountingengine.FinAbstractDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAbstractDO;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinAbstractRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinAbstractDetailRepo finAbstractDetailRepo;
    private final FinAbstractRepo finAbstractRepo;
    private final QFinAbstractDO finAbstractDO = QFinAbstractDO.finAbstractDO;

    public PagingVO<FinAbstractDTO> page(FinAbstractParam param) {
        Predicate where = where(param);
        JPAQuery<FinAbstractDTO> query = select(FinAbstractDTO.class).where(ExpressionUtils.allOf(where));
        param.setPaging(query);
        param.fillOrders(query, finAbstractDO);

        List<FinAbstractDTO> abstractVOList = query.fetch();

        List<Long> ids = abstractVOList.stream().map(FinAbstractDTO::getId).collect(Collectors.toList());
        List<FinAbstractDetailVO> detailList = FinAbstractDetailConvert.INSTANCE.doToVo(finAbstractDetailRepo.findAllByMasIdIn(ids));

        for (FinAbstractDTO abstractVO : abstractVOList) {
            abstractVO.setDetailList(detailList.stream()
                    .filter(detail -> abstractVO.getId().equals(detail.getMasId()))
                    .collect(Collectors.toList()));
        }

        return PagingVO.<FinAbstractDTO>builder()
                .total(query.fetchCount())
                .records(abstractVOList)
                .build();
    }

    private Predicate where(FinAbstractParam param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate build = BaseRepoProc.PredicateBuilder.builder()
                .andEq(param.getEventId() != null, finAbstractDO.eventId, param.getEventId())
                .andEq(StringUtils.isNotEmpty(param.getCode()), finAbstractDO.code, param.getCode())
                .andLike(StringUtils.isNotEmpty(param.getName()), finAbstractDO.name, StringUtil.buildLikeString(param.getName()))
                .andEq(param.getStatus() != null, finAbstractDO.status, param.getStatus())
                .build();
        predicates.add(build);
        if(StringUtils.isNotEmpty(param.getCodeName())){
            Predicate predicate = finAbstractDO.code.like('%' + param.getCodeName() + '%').or(finAbstractDO.name.like('%' + param.getCodeName() + '%'));
            predicates.add(predicate);
        }
        return ExpressionUtils.allOf(predicates);
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                finAbstractDO.id,
                finAbstractDO.code,
                finAbstractDO.name,
                finAbstractDO.eventId,
                finAbstractDO.eventName,
                finAbstractDO.status,
                finAbstractDO.createTime,
                finAbstractDO.creator,
                finAbstractDO.modifyTime,
                finAbstractDO.updater
        )).from(finAbstractDO);
    }

    @Transactional
    public void updateStatus(FinAbstractParam param) {
        jpaQueryFactory.update(finAbstractDO)
                .set(finAbstractDO.status, param.getStatus())
                .where(finAbstractDO.id.in(param.getIdList())).execute();
    }

    public List<FinAbstractDO> findAllByCodeInAndStatus( List<String> abstractCodes, String status) {
        if(CollectionUtils.isEmpty(abstractCodes)){
            return Lists.newArrayList();
        }

        List<FinAbstractDO> abstractDOList = finAbstractRepo.findAllByCodeInAndStatus(abstractCodes,status);
        Assert.notEmpty(abstractDOList,"查不到组合设置");

        return abstractDOList;
    }
}
