package com.elitesland.fin.domain.service.artype;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.artype.ArTypeDtlConvert;
import com.elitesland.fin.domain.entity.artype.ArTypeDtl;
import com.elitesland.fin.domain.entity.artype.ArTypeDtlDO;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import com.elitesland.fin.infr.repo.artype.ArTypeDtlRepo;
import com.elitesland.fin.infr.repo.artype.ArTypeDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class ArTypeDtlDomainServiceImpl implements ArTypeDtlDomainService{

    private final ArTypeDtlRepo arTypeDtlRepo;
    private final ArTypeDtlRepoProc arTypeDtlRepoProc;


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void save(List<ArTypeDtl> dtlList) {
        List<ArTypeDtlDO> arTypeDtlDOList = dtlList.stream().map(ArTypeDtlConvert.INSTANCE::enToDo).collect(Collectors.toList());
        arTypeDtlRepo.saveAll(arTypeDtlDOList);
    }

    @Override
    @SysCodeProc
    public List<ArTypeDtlDTO> selectByMasId(Long masId){
        List<ArTypeDtlDO> arTypeDtlDOList = arTypeDtlRepo.findAllByMasId(masId);
        if (CollectionUtil.isEmpty(arTypeDtlDOList)){
            return Collections.EMPTY_LIST;
        }

        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDOList.stream().map(ArTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());

        return arTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public List<ArTypeDtlDTO> selectByMasIds(List<Long> masIds){
        List<ArTypeDtlDO> arTypeDtlDOList = arTypeDtlRepo.findAllByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(arTypeDtlDOList)){
            return Collections.EMPTY_LIST;
        }

        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDOList.stream().map(ArTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());

        return arTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArTypeDtlDTO> page(ArTypeDtlPageParam pageParam){
        PagingVO<ArTypeDtlDTO> pagingVO = arTypeDtlRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<ArTypeDtlDTO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        return pagingVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIdBatch(List<Long> ids){
        arTypeDtlRepo.deleteAllByMasIdIn(ids);
    }

    @Override
    @SysCodeProc
    public List<ArTypeDtlDTO> selectListByParam(ArTypeDtlPageParam pageParam){
        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlRepoProc.selectListByParam(pageParam);
        if (CollectionUtils.isEmpty(arTypeDtlDTOList)) {
            return Collections.EMPTY_LIST;
        }

        return arTypeDtlDTOList;
    }

}
