package com.elitesland.fin.application.convert.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.account.TcStatementAccountVO;
import com.elitesland.fin.entity.account.TcStatementAccountDO;
import com.elitesland.fin.param.account.TcStatementAccountParam;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 天龙对账单转换器
 *
 * @author elitesland
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface TcStatementAccountConvert {

    TcStatementAccountConvert INSTANCE = Mappers.getMapper(TcStatementAccountConvert.class);

    /**
     * 参数转换为实体
     *
     * @param param 天龙对账单参数
     * @return 天龙对账单实体
     */
    TcStatementAccountDO saveToDO(TcStatementAccountParam param);

    /**
     * 实体转换为DTO
     *
     * @param tcStatementAccountDO 天龙对账单实体
     * @return 天龙对账单DTO
     */
    TcStatementAccountVO doToVO(TcStatementAccountDO tcStatementAccountDO);

    /**
     * 实体列表转换为DTO列表
     *
     * @param tcStatementAccountDOList 天龙对账单实体列表
     * @return 天龙对账单DTO列表
     */
    List<TcStatementAccountVO> doListToVOList(List<TcStatementAccountDO> tcStatementAccountDOList);


    List<TcStatementAccountDO> voListToDOList(List<TcStatementAccountVO> tcStatementAccountDOList);

    /**
     * DTO转换为实体
     *
     * @param statementAccountVO 天龙对账单DTO
     * @return 天龙对账单实体
     */
    TcStatementAccountDO dtoToDO(TcStatementAccountVO statementAccountVO);

    /**
     * 分页VO转换
     *
     * @param doPage 天龙对账单实体分页
     * @return 天龙对账单DTO分页
     */
    PagingVO<TcStatementAccountVO> doPageToDTOPage(PagingVO<TcStatementAccountDO> doPage);
}