package com.elitesland.fin.application.facade.param.creditaccountflow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author : gyj
 * @date : 2023-2-24
 */
@Data
@ApiModel(description = "信用账户流水")
public class CreditAccountFlowParam extends CustomFieldBaseModelVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("授信组织/公司编码")
    private String ouCode;

    @ApiModelProperty("授信组织/公司名称")
    private String ouName;

    @ApiModelProperty("对象编码")
    private String objectCode;
    @ApiModelProperty("对象编码集合")
    private List<String> objectCodeList;
    @ApiModelProperty("对象名称")
    private String objectName;
    @ApiModelProperty("对象名称集合")
    private List<String> objectNameList;
    @ApiModelProperty("对象类型")
    private String objectType;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("产品线")
    private String productLine;

    @ApiModelProperty("业务员")
    private String saleUser;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("流水号集合")
    private List<String> flowNoList;

    @ApiModelProperty("交易类型")
    private String transactionType;
    @ApiModelProperty("交易类型集合")
    private List<String> transactionTypeList;
    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("信用账户类型")
    private String creditAccountType;
    @ApiModelProperty("信用账户类型集合")
    private List<String> creditAccountTypeList;
    @ApiModelProperty("信用账户类型名称")
    private String creditAccountTypeName;

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;
    @ApiModelProperty("信用账户编码集合")
    private List<String> creditAccountCodeList;
    @ApiModelProperty("信用账户名称")
    private String creditAccountName;
    @ApiModelProperty("信用账户名称集合")
    private List<String> creditAccountNameList;
    @ApiModelProperty("信用账户规则编码")
    private String creditAccountRuleCode;

    @ApiModelProperty("信用账户规则名称")
    private String creditAccountRuleName;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据集合")
    private List<String> sourceDocList;

    @ApiModelProperty("来源单号")
    private String sourceNo;
    @ApiModelProperty("来源单号集合")
    private List<String> sourceNoList;
    @ApiModelProperty("来源单据ID")
    private Long sourceId;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("优先级")
    private Integer priorityNo;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("交易日期起始")
    private LocalDateTime transactionTimeS;

    @ApiModelProperty("交易日期截至")
    private LocalDateTime transactionTimeE;

    @ApiModelProperty("发生金额从")
    private BigDecimal amountFrom;

    @ApiModelProperty("发生金额至")
    private BigDecimal amountTo;

    @ApiModelProperty("账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("可用额度")
    private BigDecimal creditAccountAvailableLimit;


    //rpc
    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据金额")
    private BigDecimal sourceDocAmount;

    @ApiModelProperty("来源单据门店编码")
    private String sourceDocStoreCode;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private boolean automaticReview;

    @ApiModelProperty("单据")
    private String doc;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal docAmount;

    @ApiModelProperty("修复时间")
    private LocalDateTime repairTime;

    @ApiModelProperty("工作流实例id")
    private String workflowProcInstId;

    @ApiModelProperty("跳过报错提示")
    private Boolean skipError;

    @ApiModelProperty("根单号")
    private String rootDocNo;

    @ApiModelProperty("根单ID")
    private String rootDocId;

    @ApiModelProperty("根单类型")
    private String rootDocType;

}
