package com.elitesland.fin.application.service.apverconfig;

import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigDtlConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigDtlSaveParam;
import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigVO;
import com.elitesland.fin.application.facade.vo.apverconfig.PayAndApOrderVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfig;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.domain.param.apverconfig.OrderParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDtlDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/2 14:37
 */
@Service
@RequiredArgsConstructor
public class ApVerConfigServiceImpl implements ApVerConfigService {

    private final PayOrderDomainService payOrderService;

    private final ApOrderDomainService apOrderService;

    private final ApVerConfigDomainService apVerConfigDomainService;

    private final ApVerConfigDtlDomainService apVerConfigDtlDomainService;

    private final ApVerRecDomainService apVerRecDomainService;

    @SysCodeProc
    @Override
    public PayAndApOrderVO queryOrderByParam(OrderParam param) {
        if (param.getOuId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "公司信息不能为空!");
        }
        if (param.getSuppId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "供应商信息不能为空!");
        }
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务日期不能为空!");
        }
        PayAndApOrderVO payAndApOrderVO = new PayAndApOrderVO();
        //放置付款单数据
        payAndApOrderVO.setPayOrderList(getPayOrderList(param));
        // 应付单列表数据
        payAndApOrderVO.setApOrderList(getApOrderList(param));
        return payAndApOrderVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<String> save(ApVerConfigSaveParam param) {
        if (param.getId() != null) {
            Map<String, ApVerConfigDtlDTO> dtlMap =
                    apVerConfigDtlDomainService.queryByMasId(param.getId())
                            .stream().collect(Collectors.toMap(ApVerConfigDtlDTO::getFieldNo, t -> t));
            Boolean aBoolean = apVerRecDomainService.queryByScId(param.getId());
            param.getConfigDtlSaveParamList().forEach(params -> {
                if (dtlMap.get(params.getFieldNo()) != null) {
                    checkFieldNo(dtlMap, aBoolean, params);
                }
            });
        }
        ApVerConfig apVerConfig = ApVerConfigConvert.INSTANCE.paramConvert(param);
        String id = apVerConfigDomainService.save(apVerConfig);
        return ApiResult.ok(id);
    }

    private static void checkFieldNo(Map<String, ApVerConfigDtlDTO> dtlMap, Boolean aBoolean, ApVerConfigDtlSaveParam params) {
        if(!dtlMap.get(params.getFieldNo()).getMatchFlag().equals(params.getMatchFlag()) && aBoolean){
            throw new BusinessException("已被核销记录关联,不允许修改匹配字段!");
        }
    }
    @SysCodeProc
    @Override
    public ApiResult<ApVerConfigVO> queryById(Long id) {
        ApVerConfigDTO apVerConfigDTO = apVerConfigDomainService.queryById(id);
        ApVerConfigVO apVerConfigVO = ApVerConfigConvert.INSTANCE.convertVo(apVerConfigDTO);
        //标记是否允许修改匹配字段
        Boolean aBoolean = apVerRecDomainService.queryByScId(id);
        apVerConfigVO.setFlag(aBoolean);
        return ApiResult.ok(apVerConfigVO);
    }

    @Override
    public ApiResult<ApVerConfigVO> getDef() {
        ApVerConfigDTO apVerConfigDTO = apVerConfigDomainService.queryDef();
        ApVerConfigVO apVerConfigVO = ApVerConfigConvert.INSTANCE.convertVo(apVerConfigDTO);
        if (apVerConfigVO == null) {
            return ApiResult.ok(new ApVerConfigVO());
        }
        return ApiResult.ok(apVerConfigVO);
    }
    @SysCodeProc
    @Override
    public ApiResult<PagingVO<ApVerConfigVO>> page(ApVerConfigPageParam param) {
        PagingVO<ApVerConfigDTO> page = apVerConfigDomainService.page(param);
        PagingVO<ApVerConfigVO> apVerConfigVOPagingVO = ApVerConfigConvert.INSTANCE.convertPage(page);
        return ApiResult.ok(apVerConfigVOPagingVO);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> updateEnable(List<Long> ids,boolean state) {
        apVerConfigDomainService.updateEnable(ids,state);
        return ApiResult.ok(ids);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long count = apVerConfigDomainService.updateDef(id);
        return ApiResult.ok(count);
    }

    @Override
    public ApiResult<List<ApVerConfigDtlVO>> queryDtl() {
        List<ApVerConfigDtlDTO> dtlDTOList = apVerConfigDtlDomainService.queryDtl();
        List<ApVerConfigDtlVO> dtlVOS = ApVerConfigDtlConvert.INSTANCE.convertVo(dtlDTOList);
        return ApiResult.ok(dtlVOS);
    }

    @Override
    public ApiResult<List<ApVerConfigVO>> queryAllConfig() {
        List<ApVerConfigDTO> apVerConfigDTOS = apVerConfigDomainService.queryAll();
        List<ApVerConfigVO> apVerConfigVOS = ApVerConfigConvert.INSTANCE.dtoToVo(apVerConfigDTOS);
        return ApiResult.ok(apVerConfigVOS);
    }


    /**
     * 获取应付单列表数据
     *
     * @param param
     * @return
     */
    private List<ApOrderVO> getApOrderList(OrderParam param) {
        ApOrderParam apOrderParam = new ApOrderParam();
        apOrderParam.setOuId(param.getOuId());
        apOrderParam.setSuppId(param.getSuppId());
        apOrderParam.setCurrCode(param.getCurrCode());
        apOrderParam.setBuDateStart(param.getBuDateStart());
        apOrderParam.setBuDateEnd(param.getBuDateEnd());
        List<ApOrderDTO> apOrderDTOList = apOrderService.getApOrderList(apOrderParam);
        List<ApOrderVO> apOrderVOS = ApOrderConvert.INSTANCE.convertList(apOrderDTOList);

        // 过滤剩余未核销金额为0的数据
        List<ApOrderVO> res = apOrderVOS.stream().filter(x -> {
                    x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
                    return x.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
                }
        ).collect(Collectors.toList());
        return res;
    }

    /**
     * 获取付款单数据
     *
     * @param param 查询参数
     * @return 付款单数据
     */
    private List<PayOrderVO> getPayOrderList(OrderParam param) {
        PayOrderParam payOrderParam = new PayOrderParam();
        payOrderParam.setOuId(param.getOuId());
        payOrderParam.setSuppId(param.getSuppId());
        payOrderParam.setCurrCode(param.getCurrCode());
        payOrderParam.setBuDateStart(param.getBuDateStart());
        payOrderParam.setBuDateEnd(param.getBuDateEnd());
        //付款单数据
        List<PayOrderDTO> payOrderDTOS = payOrderService.queryByParam(payOrderParam);
        List<PayOrderVO> payOrderVOS = PayOrderConvert.INSTANCE.dtoListToVO(payOrderDTOS);
        return payOrderVOS.stream().filter(vo -> {
            vo.setUnVerAmt(((BigDecimal) vo.getTotalAmt()).subtract((BigDecimal) vo.getVerAmt()));
            //只保留含税金额减去核销金额不为0的数据
            return ((BigDecimal) vo.getUnVerAmt()).compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
    }
}
