package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.limitadjustorder.LimitAdjustOrderVO;
import com.elitesland.fin.application.service.excel.entity.LimitAdjustExportEntity;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_LIMIT_ADJUST_EXPORT_DEFAULT_IMPL;

@Service
@AllArgsConstructor
public class DefaultLimitAdjustExportServiceImpl implements DataExport<LimitAdjustExportEntity, LimitAdjustOrderParam> {
    private final LimitAdjustOrderService limitAdjustOrderService;
    @Override
    public String getTmplCode() {
        return FIN_LIMIT_ADJUST_EXPORT_DEFAULT_IMPL;
    }
    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_LIMIT_ADJUST_LIST, businessObjectType = FinBusinessObjectConstant.FIN_LIMIT_ADJUST,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "信用额度调整单默认导出",operationCode = FinBusinessObjectConstant.FIN_LIMIT_ADJUST_EXPORT_DEFAULT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<LimitAdjustExportEntity> executeExport(LimitAdjustOrderParam queryParam) {
        PagingVO<LimitAdjustOrderVO> page = limitAdjustOrderService.page(queryParam);
        return new PagingVO<>(
            page.getTotal(), ExcelConvertUtils.convertLoosely(page.getRecords(), LimitAdjustExportEntity.class)
        );
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
